<?php


include "../database/config.php";
include "../includes/head.php";
include "includes/navbar.php";

error_reporting(0);



if(!isset($username)){
    header("Location: ../login?auth=no");
}

function limitWords($string, $word_limit) {
    // Split the string into an array of words
    $words = explode(' ', $string);
    
    // Check if the number of words is less than or equal to the limit
    if (count($words) <= $word_limit) {
        // If yes, return the original string
        return $string;
    }
    
    // Select the first $word_limit words
    $limited_words = array_slice($words, 0, $word_limit);
    
    // Join the words back into a single string
    $limited_string = implode(' ', $limited_words). '...';
    
    return $limited_string;
}


?>



<!-- Room Start -->
<div class="container-xxl py-5">
    <div class="container">
        <div class="text-center wow fadeInUp" data-wow-delay="0.1s">
            <h6 class="section-title text-center text-primary text-uppercase">Checkedin Guests</h6>
            <h1 class="mb-5">Pending <span class="text-primary text-uppercase">Checkouts</span></h1>
        </div>
        
        <div class="row g-4">

        <?php

            if($_GET["confirm"] == "yes"){
                echo "<span class='alert alert-success'>Guest has successfully checkedout</span>" ;
            }
        
            $select_hotel_reservations = "SELECT * FROM reservations WHERE is_confirmed = 1 AND is_checked_out = 0";
            $select_hotel_rooms_result = mysqli_query($conn, $select_hotel_reservations);
            while($reservation = mysqli_fetch_assoc($select_hotel_rooms_result)){

                $reservation_id = $reservation["id"];
                $room_code = $reservation["room_code"];
                $guest_name = $reservation["guest_name"];
                
                $select_hotel_checkins = "SELECT * FROM checkin_checkouts WHERE reservations_id = $reservation_id AND room_code = $room_code ";
                $select_hotel_checkins_result = mysqli_query($conn, $select_hotel_checkins);
                $checkins = mysqli_fetch_assoc($select_hotel_checkins_result);

                $checkin_id = $checkins["id"];
                $checkin_date = $checkins["checkin_date"];
                $checkedin_by = $checkins["checkedin_by"];


                $select_hotel_room_images = "SELECT * FROM hotel_rooms WHERE room_code = $room_code";
                $select_hotel_room_images_result = mysqli_query($conn, $select_hotel_room_images);
                $image = mysqli_fetch_assoc($select_hotel_room_images_result);

                $image_id = $image["id"];
                $main_image = $image["main_image"];
                $room_title = $image["room_title"];



                
                $room_description = limitWords($room_descriptions, 20, "...");


        
        ?>


            <div class="col-lg-4 col-md-6 wow fadeInUp" data-wow-delay="0.1s">
                <div class="room-item shadow rounded overflow-hidden">
                    <div class="position-relative">
                        <img class="img-fluid" src="img/hotel_rooms/<?= $main_image ?>" alt="" style="width:500px; height:200px; object-fit:cover">
                        <small class="position-absolute start-0 top-100 translate-middle-y bg-primary text-white rounded py-1 px-3 ms-4"><?= $room_title ?></small>
                    </div>
                    <div class="p-4 mt-2">
                        <h6 class="text-body mb-3">Guest Name: <span style="color:black"><?= $guest_name ?></span> </h6>
                        <h6 class="text-body mb-3">Checkedin By: <span style="color:black"><?= $checkedin_by ?></span> </h6>
                        <h6 class="text-body mb-3">Checkin Date: <span style="color:black"><?= $checkin_date ?></span> </h6>
                        <div class="d-flex justify-content-between">
                            <a class="btn btn-sm btn-primary rounded py-2 px-4" href="checkout_visitor?room_code=<?= $room_code ?>&hotel_user=<?= $username; ?>&checkin_id=<?= $checkin_id ?>">Checkout Guest</a>
                        </div>
                    </div>
                </div>
            </div>
            
        <?php }?>


        </div>
    </div>
    
</div>
<!-- Room End -->
<br><br>
<br><br>
<!-- <div class="text-center wow fadeInUp" data-wow-delay="0.1s">
    <h6 class="section-title text-center text-primary text-uppercase">Archives</h6>
    <h1 class="mb-5">Old <span class="text-primary text-uppercase">Reservations</span></h1>
</div> -->