<?php


include "../database/config.php";
include "../includes/head.php";
include "includes/navbar.php";

//error_reporting(0);



if(!isset($username)){
    header("Location: ../login?auth=no");
}

function limitWords($string, $word_limit) {
    // Split the string into an array of words
    $words = explode(' ', $string);
    
    // Check if the number of words is less than or equal to the limit
    if (count($words) <= $word_limit) {
        // If yes, return the original string
        return $string;
    }
    
    // Select the first $word_limit words
    $limited_words = array_slice($words, 0, $word_limit);
    
    // Join the words back into a single string
    $limited_string = implode(' ', $limited_words). '...';
    
    return $limited_string;
}


?>



<!-- Room Start -->
<div class="container-xxl py-5">
    <div class="container">
        <div class="text-center wow fadeInUp" data-wow-delay="0.1s">
            <h6 class="section-title text-center text-primary text-uppercase">Guest </h6>
            <h1 class="mb-5">Movement <span class="text-primary text-uppercase">History</span></h1>
        </div>
        
        <div class="row g-4">

            <table id="table" class="table table-stripe">
                <thead>
                    <tr>
                        <th>Guest Name</th>
                        <th>Booked Room No</th>
                        <th>On the</th>
                        <th>CheckedIn on</th>
                        <th>CheckedIn By</th>
                        <th>CheckedOut On</th>
                        <th>CheckedOut by</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                        //get the date checkedin and out
                        $get_reservations_movement= "SELECT * FROM checkin_checkouts" ;
                        $get_reservations_movement_query = mysqli_query($conn, $get_reservations_movement);
                        while($movement = mysqli_fetch_assoc($get_reservations_movement_query)){
                            
                            $checkedin_on = $movement["checkin_date"] ;
                            $checkedin_by = $movement["checkedin_by"] ;
                            $checkedout_on = $movement["checkout_date"] ;
                            $checkedout_by = $movement["checkedout_by"] ;
                            $room_code = $movement["room_code"] ;

                            $get_rooms = "SELECT * FROM hotel_rooms WHERE room_code =  $room_code" ;
                            $get_room_query = mysqli_query($conn, $get_rooms);
                            $rooms = mysqli_fetch_assoc($get_room_query);

                            $room_no = $rooms["room_no"] ;

                            //get the reservations details
                            $get_reservations= "SELECT * FROM reservations WHERE room_code = $room_code" ;
                            $get_reservations_query = mysqli_query($conn, $get_reservations);
                            $reservation = mysqli_fetch_assoc($get_reservations_query) ;
                            $guest_name = $reservation["guest_name"] ;
                            $date_reserved = $reservation["date_reserved"] ;

                            $datere = DateTime::createFromFormat('Y-m-d H:i:s', $date_reserved);

                            $reservations_date = $datere->format('l F j, Y g:i A');

                        
                    ?>
                        <tr>
                            <td><?= $guest_name ?></td>
                            <td><?= $room_no ?></td>
                            <td><?= $reservations_date ?></td>
                            <td><?= $checkedin_on ?></td>
                            <td><?= $checkedin_by ?></td>
                            <td><?= $checkedout_on ?></td>
                            <td><?= $checkedout_by ?></td>
                        </tr>
                    <?php } ?>
                </tbody>
            </table>


        </div>
    </div>
    
</div>
<!-- Room End -->
<br><br>
<br><br>
<!-- <div class="text-center wow fadeInUp" data-wow-delay="0.1s">
    <h6 class="section-title text-center text-primary text-uppercase">Archives</h6>
    <h1 class="mb-5">Old <span class="text-primary text-uppercase">Reservations</span></h1>
</div> -->