<?php

include "../../database/config.php";
include "../../database/temp_db.php";


if(isset($_POST['save_continue'])){

    $room_name = $_POST["room_title"];
    $room_price = $_POST["room_price"];
    $no_beds = $_POST["no_beds"];
    $no_baths = $_POST["no_baths"];
    $adult = $_POST["adult"];
    $kids = $_POST["kids"];
    $wifi = $_POST["wifi"];
    $room_description = $_POST["room_description"];
    $room_no = $_POST["room_no"];
    $room_code = $_POST["room_code"];


    $main_image = !empty($_FILES["main_image"]["name"])
    ? sha1_file($_FILES['main_image']['tmp_name']) . "-" . basename($_FILES["main_image"]["name"])
    : "";

    $main_image=htmlspecialchars(strip_tags($main_image));



    $insert_hotel_room_query = "INSERT INTO hotel_rooms SET room_title=:room_title, room_price=:room_price, no_beds=:no_beds, no_baths=:no_baths, 
    adult=:adult, kids=:kids, wifi=:wifi, status=0, room_description=:room_description, room_code=:room_code, room_no=:room_no, main_image=:main_image" ;
    $prepare_inswert_query = $temp_db->prepare($insert_hotel_room_query);

    $prepare_inswert_query->bindParam(":room_title", $room_name);
    $prepare_inswert_query->bindParam(":room_price", $room_price);
    $prepare_inswert_query->bindParam(":no_beds", $no_beds);
    $prepare_inswert_query->bindParam(":no_baths", $no_baths);
    $prepare_inswert_query->bindParam(":adult", $adult);
    $prepare_inswert_query->bindParam(":kids", $kids);
    $prepare_inswert_query->bindParam(":wifi", $wifi);
    $prepare_inswert_query->bindParam(":room_description", $room_description);
    $prepare_inswert_query->bindParam(":room_code", $room_code);
    $prepare_inswert_query->bindParam(":room_no", $room_no);
    $prepare_inswert_query->bindParam(":main_image", $main_image);

    if($prepare_inswert_query->execute()){

        if($main_image){
            // sha1_file() function is used to make a unique file name
            $target_directory = "../img/hotel_rooms/";
            $target_file = $target_directory . $main_image;
            $file_type = pathinfo($target_file, PATHINFO_EXTENSION);
        
            $file_upload_error_messages="";
            // make sure file does not exist
            if(file_exists($target_file)){
                $file_upload_error_messages.="<div>File already exists. Try to change file name.</div>";
            }
            
            // if $file_upload_error_messages is still empty
            if(empty($file_upload_error_messages)){
                // it means there are no errors, so try to upload the file
                if(move_uploaded_file($_FILES["main_image"]["tmp_name"], $target_file)){
                    // it means photo was uploaded
                }else{
                    echo "<div class='alert alert-danger'>
                        <div>Unable to upload file.</div>
                        <div>Update the record to upload file.</div>
                    </div>";
                }
            }
        }

        header("Location: ../save_continue_hotel_room?room_code=$room_code");
    }else{
        header("Location: ../add_room?error=yes");
    }

}






if(isset($_POST['edit_save_continue'])){

    $room_name = $_POST["room_title"];
    $room_price = $_POST["room_price"];
    $no_beds = $_POST["no_beds"];
    $no_baths = $_POST["no_baths"];
    $adult = $_POST["adult"];
    $kids = $_POST["kids"];
    $wifi = $_POST["wifi"];
    $room_description = $_POST["room_description"];
    $room_no = $_POST["room_no"];
    $room_code = $_POST["room_code"];


    $main_image = !empty($_FILES["main_image"]["name"])
    ? sha1_file($_FILES['main_image']['tmp_name']) . "-" . basename($_FILES["main_image"]["name"])
    : "";

    $main_image=htmlspecialchars(strip_tags($main_image));


    if($main_image == ""){
        $insert_hotel_room_query = "UPDATE hotel_rooms SET room_title=:room_title, room_price=:room_price, no_beds=:no_beds, no_baths=:no_baths, 
        adult=:adult, kids=:kids, wifi=:wifi, room_description=:room_description, room_no=:room_no WHERE room_code = $room_code" ;
        
        $prepare_inswert_query = $temp_db->prepare($insert_hotel_room_query);

        $prepare_inswert_query->bindParam(":room_title", $room_name);
        $prepare_inswert_query->bindParam(":room_price", $room_price);
        $prepare_inswert_query->bindParam(":no_beds", $no_beds);
        $prepare_inswert_query->bindParam(":no_baths", $no_baths);
        $prepare_inswert_query->bindParam(":adult", $adult);
        $prepare_inswert_query->bindParam(":kids", $kids);
        $prepare_inswert_query->bindParam(":wifi", $wifi);
        $prepare_inswert_query->bindParam(":room_description", $room_description);
        $prepare_inswert_query->bindParam(":room_no", $room_no);

        if($prepare_inswert_query->execute()){
            header("Location: ../save_continue_hotel_room?room_code=$room_code");
        }else{
            header("Location: ../add_room?error=yes");
        }
    }else{
        $insert_hotel_room_query = "UPDATE hotel_rooms SET room_title=:room_title, room_price=:room_price, no_beds=:no_beds, no_baths=:no_baths, 
        adult=:adult, kids=:kids, wifi=:wifi, room_description=:room_description, room_no=:room_no, main_image=:main_image WHERE room_code = $room_code" ;

        
        $prepare_inswert_query = $temp_db->prepare($insert_hotel_room_query);

        $prepare_inswert_query->bindParam(":room_title", $room_name);
        $prepare_inswert_query->bindParam(":room_price", $room_price);
        $prepare_inswert_query->bindParam(":no_beds", $no_beds);
        $prepare_inswert_query->bindParam(":no_baths", $no_baths);
        $prepare_inswert_query->bindParam(":adult", $adult);
        $prepare_inswert_query->bindParam(":kids", $kids);
        $prepare_inswert_query->bindParam(":wifi", $wifi);
        $prepare_inswert_query->bindParam(":room_description", $room_description);
        $prepare_inswert_query->bindParam(":room_no", $room_no);
        $prepare_inswert_query->bindParam(":main_image", $main_image);

        if($prepare_inswert_query->execute()){

            if($main_image){
                // sha1_file() function is used to make a unique file name
                $target_directory = "../img/hotel_rooms/";
                $target_file = $target_directory . $main_image;
                $file_type = pathinfo($target_file, PATHINFO_EXTENSION);
            
                $file_upload_error_messages="";
                // make sure file does not exist
                if(file_exists($target_file)){
                    $file_upload_error_messages.="<div>File already exists. Try to change file name.</div>";
                }
                
                // if $file_upload_error_messages is still empty
                if(empty($file_upload_error_messages)){
                    // it means there are no errors, so try to upload the file
                    if(move_uploaded_file($_FILES["main_image"]["tmp_name"], $target_file)){
                        // it means photo was uploaded
                    }else{
                        echo "<div class='alert alert-danger'>
                            <div>Unable to upload file.</div>
                            <div>Update the record to upload file.</div>
                        </div>";
                    }
                }
            }

            header("Location: ../save_continue_hotel_room?room_code=$room_code");
        }else{
            header("Location: ../add_room?error=yes");
        }
    }


}





if(isset($_POST["add_image"])){

    $room_code = $_POST["room_code"];

    $room_image = !empty($_FILES["room_image"]["name"])
    ? sha1_file($_FILES['room_image']['tmp_name']) . "-" . basename($_FILES["room_image"]["name"])
    : "";

    $room_image=htmlspecialchars(strip_tags($room_image));

    $insert_image = "INSERT INTO room_images SET room_code=:room_code, room_image=:room_image" ;
    $prepare_image = $temp_db->prepare($insert_image);

    //Bind Param,eters
    $prepare_image->bindParam(":room_code", $room_code) ;
    $prepare_image->bindParam(":room_image", $room_image) ;

    if($prepare_image->execute()){
        if($room_image){
            // sha1_file() function is used to make a unique file name
            $target_directory = "../img/hotel_rooms/";
            $target_file = $target_directory . $room_image;
            $file_type = pathinfo($target_file, PATHINFO_EXTENSION);
        
            $file_upload_error_messages="";
            // make sure file does not exist
            if(file_exists($target_file)){
                $file_upload_error_messages.="<div>File already exists. Try to change file name.</div>";
            }
            
            // if $file_upload_error_messages is still empty
            if(empty($file_upload_error_messages)){
                // it means there are no errors, so try to upload the file
                if(move_uploaded_file($_FILES["room_image"]["tmp_name"], $target_file)){
                    // it means photo was uploaded
                }else{
                    echo "<div class='alert alert-danger'>
                        <div>Unable to upload file.</div>
                        <div>Update the record to upload file.</div>
                    </div>";
                }
            }
        }

        //Update status of the room as 1
        $update_room_status = "UPDATE hotel_rooms SET status=1 WHERE room_code = $room_code" ;
        $prep_update = $temp_db->prepare($update_room_status);
        if($prep_update->execute()){
            header("Location: ../save_continue_hotel_room?room_code=$room_code&add=yes");
        }
    }else{
        header("Location: ../save_continue_hotel_room?room_code=$room_code&add=no");
    }


}