<?php


include "../database/config.php";
include "../includes/head.php";
include "includes/navbar.php";

error_reporting(0);



if(!isset($username)){
    header("Location: ../login?auth=no");
}

function limitWords($string, $word_limit) {
    // Split the string into an array of words
    $words = explode(' ', $string);
    
    // Check if the number of words is less than or equal to the limit
    if (count($words) <= $word_limit) {
        // If yes, return the original string
        return $string;
    }
    
    // Select the first $word_limit words
    $limited_words = array_slice($words, 0, $word_limit);
    
    // Join the words back into a single string
    $limited_string = implode(' ', $limited_words). '...';
    
    return $limited_string;
}


?>



<!-- Room Start -->
<div class="container-xxl py-5">
    <div class="container">
        <a href="add_room" class="btn btn-primary rounded-0 ">Add Rooms<i class="fa fa-plus ms-3"></i></a>
        <?php

            if($_GET["delete"] == "oui"){
                
                $roomID = $_GET["room_id"] ;
        ?>
        <div class="alert alert-danger">
            Room Deleted
            <a href="undo_delete?room_id=<?= $roomID  ?>" class="btn btn-danger rounded-0 ">Undo</a>
        </div>

        <?php }
            if($_GET["undo"] == "oui"){
        ?>

            <div class="alert alert-success">
                Deleted Undone
            </div>

        <?php } ?>
        
        <br><br>
        <br><br>
        <div class="text-center wow fadeInUp" data-wow-delay="0.1s">
            <h6 class="section-title text-center text-primary text-uppercase">All Rooms</h6>
        </div>
        <br><br>
        <div class="row g-4">

        <?php
        
            $select_hotel_rooms = "SELECT * FROM hotel_rooms WHERE is_delete != 1";
            $select_hotel_rooms_result = mysqli_query($conn, $select_hotel_rooms);
            while($room = mysqli_fetch_assoc($select_hotel_rooms_result)){

                $room_id = $room["id"];
                $room_title = $room["room_title"];
                $room_prices = $room["room_price"];
                $no_beds = $room["no_beds"];
                $no_baths = $room["no_baths"];
                $adult = $room["adult"];
                $kids = $room["kids"];
                $wifi = $room["wifi"];
                $status = $room["status"];
                $room_descriptions = $room["room_description"];
                $room_code = $room["room_code"];
                $room_no = $room["room_no"];
                $is_reserved = $room["is_reserved"];
                $main_image = $room["main_image"];

                $room_price = number_format($room_prices, 0, '.', ',');


                // $select_hotel_room_images = "SELECT * FROM room_images WHERE room_code = $room_code";
                // $select_hotel_room_images_result = mysqli_query($conn, $select_hotel_room_images);
                // $image = mysqli_fetch_assoc($select_hotel_room_images_result);

                // $image_id = $image["id"];
                // $room_image = $image["room_image"];

                
                $room_description = limitWords($room_descriptions, 20, "...");




                // To set defult timezone
                date_default_timezone_set("Africa/Douala");

                $time_now = date( 'm/d/Y h:i A');

                // Convert user input dates to UNIX timestamp for easier comparison
                $user_checkin_timestamp = strtotime($time_now);
                $user_checkout_timestamp = strtotime($time_now);

                // Fetch existing reservations for the room from the database
                $sql = "SELECT checkin, checkout FROM reservations WHERE room_code = ?";
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("i", $room_code);
                $stmt->execute();
                $result = $stmt->get_result();

                // Check for overlap with existing reservations
                $room_available = true;
                while ($row = $result->fetch_assoc()) {
                    $existing_checkin_timestamp = strtotime($row['checkin']);
                    $existing_checkout_timestamp = strtotime($row['checkout']);
                    
                    // Check for overlap
                    if (
                        ($user_checkin_timestamp < $existing_checkout_timestamp && $user_checkout_timestamp > $existing_checkin_timestamp)
                        || ($user_checkin_timestamp == $existing_checkout_timestamp && $user_checkout_timestamp == $existing_checkin_timestamp)
                    ) {
                        $room_available = false;
                        break;
                    }
                }

                if ($room_available) {
                    $is_available = "yes" ;
                }else{
                    $is_available = "no" ;
                }



        
        
        ?>


            <div class="col-lg-4 col-md-6 wow fadeInUp" data-wow-delay="0.1s">
                <div class="room-item shadow rounded overflow-hidden">
                    <div class="position-relative">
                        <img class="img-fluid" src="img/hotel_rooms/<?= $main_image ?>" alt="" style="width:500px; height:200px; object-fit:cover">
                        <small class="position-absolute start-0 top-100 translate-middle-y bg-primary text-white rounded py-1 px-3 ms-4">CFA <?= $room_price ?>/Night</small>
                        <?php

                            if($is_available == "no"){
                        ?>
                            <small class=" start-0 top-100 translate-middle-y text-white rounded py-1 px-3 ms-4" style="float:right; margin-right: 24px; background-color: #fe1616 !important;">Not Available Today</small>
                        <?php }else{?>
                            <small class=" start-0 top-100 translate-middle-y text-white rounded py-1 px-3 ms-4" style="float:right; margin-right: 24px; background-color: #00c10f !important;">Available Today</small>
                        <?php }?>
                    </div>
                    <div class="p-4 mt-2">
                        <div class="d-flex justify-content-between mb-3">
                            <h5 class="mb-0"><?= $room_title ?></h5>
                            <div class="ps-2">
                                <small class="fa fa-star text-primary"></small>
                                <small class="fa fa-star text-primary"></small>
                                <small class="fa fa-star text-primary"></small>
                                <small class="fa fa-star text-primary"></small>
                                <small class="fa fa-star "></small>
                            </div>
                        </div>
                        <div class="d-flex mb-3">
                            <small class="border-end me-3 pe-3"><i class="fa fa-bed text-primary me-2"></i><?= $no_beds ?> Bed</small>
                            <small class="border-end me-3 pe-3"><i class="fa fa-bath text-primary me-2"></i><?= $no_baths ?> Bath</small>
                            <?php

                                if($wifi == 1){
                            ?>
                                <small><i class="fa fa-wifi text-primary me-2"></i>Wifi</small>
                            <?php }?>
                        </div>
                        <p class="text-body mb-3"><?= $room_description ?></p>
                        <div class="d-flex justify-content-between">
                            <a class="btn btn-sm btn-primary rounded py-2 px-4" href="delete_room?room_id=<?= $room_id ?>">Delete</a>
                            <a class="btn btn-sm btn-dark rounded py-2 px-4" href="edit_room?room_code=<?= $room_code ?>">Edit</a>
                        </div>
                    </div>
                </div>
            </div>
            
        <?php }?>


        </div>

    </div>
</div>
<!-- Room End -->