<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

include "../database/config.php";

$room_code = $_GET["room_code"]; // Assuming you want to fetch bookings for a specific room

$sql = "SELECT checkin, checkout FROM reservations WHERE room_code = ?";
$stmt = $conn->prepare($sql);
if (!$stmt) {
    die("Prepare failed: " . $conn->error);
}
$stmt->bind_param("i", $room_code);
$stmt->execute();
$result = $stmt->get_result();

$events = [];
while ($row = $result->fetch_assoc()) {
    $events[] = [
        'title' => 'Booked',
        'start' => date('Y-m-d', strtotime($row['checkin'])),
        'end' => date('Y-m-d', strtotime($row['checkout'] . ' +1 day')), // FullCalendar expects the end date to be exclusive
        'display' => 'background',
        'color' => '#ff9f89' // Optional: Change the color of the booked dates
    ];
}

header('Content-Type: application/json');
echo json_encode($events);
?>
