<?php

include "../database/config.php";
include "../database/temp_db.php";

$guest_name = $_POST["guest_name"];
$user_checkin = $_POST["checkin"];
$user_checkout = $_POST["checkout"];
$room_code = $_POST["room_code"];
$guest_tel = $_POST["guest_tel"];
$guest_gender = $_POST["guest_gender"];
$adults = $_POST["adults"];
$kids = $_POST["kids"];
$special_note = $_POST["special_note"];
$reservation_code = rand(9332,785) ;

// Convert user input dates to UNIX timestamp for easier comparison
$user_checkin_timestamp = strtotime($user_checkin);
$user_checkout_timestamp = strtotime($user_checkout);

// Fetch existing reservations for the room from the database
$sql = "SELECT checkin, checkout FROM reservations WHERE room_code = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $room_code);
$stmt->execute();
$result = $stmt->get_result();

// Check for overlap with existing reservations
$room_available = true;
while ($row = $result->fetch_assoc()) {
    $existing_checkin_timestamp = strtotime($row['checkin']);
    $existing_checkout_timestamp = strtotime($row['checkout']);
    
    // Check for overlap
    if (
        ($user_checkin_timestamp < $existing_checkout_timestamp && $user_checkout_timestamp > $existing_checkin_timestamp)
        || ($user_checkin_timestamp == $existing_checkout_timestamp && $user_checkout_timestamp == $existing_checkin_timestamp)
    ) {
        $room_available = false;
        break;
    }
}

if ($room_available) {
    
    //I want to verify if the number of adults and kids are ok with the room's requirments

    $select_room = "SELECT * FROM hotel_rooms WHERE room_code = $room_code " ;
    $select_query = mysqli_query($conn, $select_room);
    $result = mysqli_fetch_assoc($select_query);

    $room_kids = $result["kids"];
    $room_adults = $result["adult"];

    if($kids > $room_kids){
        echo "Too many kids than the required number" ;
    }elseif($adults > $room_adults){
        echo "Too many Adults than the required number" ;
    }else{
        //Now insert the booking into the table because all conditions have been met
        $insert_query = "INSERT INTO reservations SET room_code=:room_code, guest_name=:guest_name, guest_tel=:guest_tel, guest_gender=:guest_gender, adults=:adults, kids=:kids,
        checkin=:checkin, checkout=:checkout, reservation_code=:reservation_code, special_note=:special_note, is_confirmed=0" ;
        $prepare_statement = $temp_db->prepare($insert_query);

        $prepare_statement->bindParam(":room_code", $room_code);
        $prepare_statement->bindParam(":guest_name", $guest_name);
        $prepare_statement->bindParam(":guest_tel", $guest_tel);
        $prepare_statement->bindParam(":guest_gender", $guest_gender);
        $prepare_statement->bindParam(":adults", $adults);
        $prepare_statement->bindParam(":kids", $kids);
        $prepare_statement->bindParam(":checkin", $user_checkin);
        $prepare_statement->bindParam(":checkout", $user_checkout);
        $prepare_statement->bindParam(":reservation_code", $reservation_code);
        $prepare_statement->bindParam(":special_note", $special_note);

        if($prepare_statement->execute()){
            echo "Congratulations, Your reservations have been made. You will receive a call from our staff to confirm you booking" ;
        }
    }

} else {
    echo "Sorry!!! This room is not available for the selected dates. Please check the calendar to see available dates";
}


