<?php

include '../database/config2.php';


if (isset($_POST['post_eulogy'])) {

    // posted values
    $name = $_POST['name'];
    $relation = $_POST['relation'];
    $text = $_POST['text'];
    $id = $_POST['id'];
    $time = date("M d Y, h:i");

    $profile = !empty($_FILES["profile"]["name"])
    ? sha1_file($_FILES['profile']['tmp_name']) . "-" . basename($_FILES["profile"]["name"])
    : "";

    $profile=htmlspecialchars(strip_tags($profile));

    if($id == ""){
        // insert query
        $insert_eulogy = "INSERT INTO eologies SET name=:name, relation=:relation, profile=:profile, text=:text, time=:time";
    }else{
        // insert query
        $insert_eulogy = "UPDATE eologies SET name=:name, relation=:relation, profile=:profile, text=:text, time=:time WHERE id = $id";
    }

    

    // prepare query for execution
    $insert_eulogy_stmt = $conn->prepare($insert_eulogy);






    // bind the parameters
    $insert_eulogy_stmt->bindParam(':name', $name);
    $insert_eulogy_stmt->bindParam(':relation', $relation);
    $insert_eulogy_stmt->bindParam(':text', $text);
    $insert_eulogy_stmt->bindParam(':time', $time);
    $insert_eulogy_stmt->bindParam(':profile', $profile);

    // Execute the query
    if($insert_eulogy_stmt->execute()){

        if($profile){
            
            // sha1_file() function is used to make a unique file name
            $target_directory = "../img/profiles/";
            $target_file = $target_directory . $profile;
            $file_type = pathinfo($target_file, PATHINFO_EXTENSION);
        
            $file_upload_error_messages="";
            // make sure file does not exist
            if(file_exists($target_file)){
                $file_upload_error_messages.="<div>File already exists. Try to change file name.</div>";
            }
            
            // if $file_upload_error_messages is still empty
            if(empty($file_upload_error_messages)){
                // it means there are no errors, so try to upload the file
                if(move_uploaded_file($_FILES["profile"]["tmp_name"], $target_file)){
                    // it means photo was uploaded
                }else{
                    echo "<div class='alert alert-danger'>
                        <div>Unable to upload file.</div>
                        <div>Update the record to upload file.</div>
                    </div>";
                }
            }
        }

        header("Location: ../write_eulogy?add=yes");
        
    }else{
        header("Location: ../write_eulogy?add=no");
    }



}





if (isset($_POST['upload_image'])) {

    // posted values
    $image_url = !empty($_FILES["image_url"]["name"])
    ? sha1_file($_FILES['image_url']['tmp_name']) . "-" . basename($_FILES["image_url"]["name"])
    : "";

    $image_url=htmlspecialchars(strip_tags($image_url));

    // insert query
    $insert_eulogy = "INSERT INTO images SET image_url=:image_url";

    // prepare query for execution
    $insert_eulogy_stmt = $conn->prepare($insert_eulogy);



    // bind the parameters
    $insert_eulogy_stmt->bindParam(':image_url', $image_url);

    // Execute the query
    if($insert_eulogy_stmt->execute()){

        if($image_url){
            
            // sha1_file() function is used to make a unique file name
            $target_directory = "../img/gallery/";
            $target_file = $target_directory . $image_url;
            $file_type = pathinfo($target_file, PATHINFO_EXTENSION);
        
            $file_upload_error_messages="";
            // make sure file does not exist
            if(file_exists($target_file)){
                $file_upload_error_messages.="<div>File already exists. Try to change file name.</div>";
            }
            
            // if $file_upload_error_messages is still empty
            if(empty($file_upload_error_messages)){
                // it means there are no errors, so try to upload the file
                if(move_uploaded_file($_FILES["image_url"]["tmp_name"], $target_file)){
                    // it means photo was uploaded
                }else{
                    echo "<div class='alert alert-danger'>
                        <div>Unable to upload file.</div>
                        <div>Update the record to upload file.</div>
                    </div>";
                }
            }
        }

        header("Location: ../uplaod_image?add=yes");
        
    }else{
        header("Location: ../uplaod_image?add=no");
    }



}




if (isset($_POST['add_programme'])) {

    // posted values
    $date = $_POST['date'];
    $time = $_POST['time'];
    $location = $_POST['location'];
    $narration = $_POST['narration'];
    $id = $_POST['id'];

    if($id == ""){
        // insert query
        $add_programme = "INSERT INTO programme SET date=:date, time=:time, location=:location, narration=:narration";
    }else{
        // insert query
        $add_programme = "UPDATE programme SET date=:date, time=:time, location=:location, narration=:narration WHERE id = $id";
    }


    // prepare query for execution
    $add_programme_stmt = $conn->prepare($add_programme);



    // bind the parameters
    $add_programme_stmt->bindParam(':date', $date);
    $add_programme_stmt->bindParam(':time', $time);
    $add_programme_stmt->bindParam(':location', $location);
    $add_programme_stmt->bindParam(':narration', $narration);

    // Execute the query
    if($add_programme_stmt->execute()){

        header("Location: ../add_programme?add=yes");
        
    }else{
        header("Location: ../add_programme?add=no");
    }



}