<?php

include "database/config.php";
include "database/temp_db.php";
include "includes/head.php";
include "includes/navbar.php";

error_reporting(0);


function limitWords($string, $word_limit) {
    // Split the string into an array of words
    $words = explode(' ', $string);
    
    // Check if the number of words is less than or equal to the limit
    if (count($words) <= $word_limit) {
        // If yes, return the original string
        return $string;
    }
    
    // Select the first $word_limit words
    $limited_words = array_slice($words, 0, $word_limit);
    
    // Join the words back into a single string
    $limited_string = implode(' ', $limited_words). '...';
    
    return $limited_string;
}


$select_hotel_rooms = "SELECT * FROM hotel_rooms WHERE is_delete != 1 LIMIT 6";
$select_hotel_rooms_result = mysqli_query($conn, $select_hotel_rooms);
$count_rooms = mysqli_num_rows($select_hotel_rooms_result);

?>
        <!-- Carousel Start -->
        <div class="container-fluid p-0 mb-5">
            <div id="header-carousel" class="carousel slide" data-bs-ride="carousel">
                <div class="carousel-inner">
                    <div class="carousel-item active">
                        <img class="w-100" src="img/holidaysinn_carousel.jpg" alt="Image">
                        <div class="carousel-caption d-flex flex-column align-items-center justify-content-center">
                            <div class="p-3" style="max-width: 700px;">
                                <h6 class="section-title text-white text-uppercase mb-3 animated slideInDown">Luxury Living</h6>
                                <h1 class="display-3 text-white mb-4 animated slideInDown">Welcome to Holiday Inn Resort Limbe</h1>
                                <a href="room" class="btn btn-primary py-md-3 px-md-5 me-3 animated slideInLeft">Our Rooms</a>
                                <a href="room" class="btn btn-light py-md-3 px-md-5 animated slideInRight">Book A Room</a>
                            </div>
                        </div>
                    </div>
                    <div class="carousel-item">
                        <img class="w-100" src="img/holidaysinn_carousel1.jpg" alt="Image">
                        <div class="carousel-caption d-flex flex-column align-items-center justify-content-center">
                            <div class="p-3" style="max-width: 700px;">
                                <h6 class="section-title text-white text-uppercase mb-3 animated slideInDown">Luxury Living</h6>
                                <h1 class="display-3 text-white mb-4 animated slideInDown">Discover A Brand Luxurious Hotel</h1>
                                <a href="room" class="btn btn-primary py-md-3 px-md-5 me-3 animated slideInLeft">Our Rooms</a>
                                <a href="booking" class="btn btn-light py-md-3 px-md-5 animated slideInRight">Book A Room</a>
                            </div>
                        </div>
                    </div>
                </div>
                <button class="carousel-control-prev" type="button" data-bs-target="#header-carousel"
                    data-bs-slide="prev">
                    <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                    <span class="visually-hidden">Previous</span>
                </button>
                <button class="carousel-control-next" type="button" data-bs-target="#header-carousel"
                    data-bs-slide="next">
                    <span class="carousel-control-next-icon" aria-hidden="true"></span>
                    <span class="visually-hidden">Next</span>
                </button>
            </div>
        </div>
        <!-- Carousel End -->


        <!-- Booking Start -->
        <div class="container-fluid booking pb-5 wow fadeIn" data-wow-delay="0.1s">
            <div class="container">
                <div class="bg-white shadow" style="padding: 35px;">
                    <form action="search" method="GET">
                        <div class="row g-2">
                            <div class="col-md-10">
                                <div class="row g-2">
                                    <div class="col-md-3">
                                        <div class="date" id="date1" data-target-input="nearest">
                                            <input type="text" class="form-control datetimepicker-input"
                                                placeholder="Check in" name="checkin" data-target="#date1" data-toggle="datetimepicker" />
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="date" id="date2" data-target-input="nearest">
                                            <input type="text" class="form-control datetimepicker-input" name="checkout" placeholder="Check out" data-target="#date2" data-toggle="datetimepicker"/>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <select class="form-select" name="adult">
                                            <option selected>Adult</option>
                                            <option value="1">Adult 1</option>
                                            <option value="2">Adult 2</option>
                                            <option value="3">Adult 3</option>
                                            <option value="4">Adult 4</option>
                                            <option value="5">Adult 5</option>
                                            <option value="6">Adult 6</option>
                                        </select>
                                    </div>
                                    <div class="col-md-3">
                                        <select class="form-select" name="kids">
                                            <option selected>Child</option>
                                            <option value="0">No Child</option>
                                            <option value="1">Child 1</option>
                                            <option value="2">Child 2</option>
                                            <option value="3">Child 3</option>
                                            <option value="4">Child 4</option>
                                            <option value="5">Child 5</option>
                                            <option value="6">Child 6</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <button class="btn btn-primary w-100" name="s">Search</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <!-- Booking End -->


        <!-- About Start -->
        <div class="container-xxl py-5">
            <div class="container">
                <div class="row g-5 align-items-center">
                    <div class="col-lg-6">
                        <h6 class="section-title text-start text-primary text-uppercase">About Us</h6>
                        <h1 class="mb-4">Welcome to <span class="text-primary text-uppercase">Holiday Inn</span></h1>
                        <p class="mb-4">Holiday Inn Resort (HIR) is a 3 Stars hotel found in the heart of the coastal city of Limbe-Cameroon. Its services are classic, and very affordable.</p>
                        <div class="row g-3 pb-4">
                            <div class="col-sm-4 wow fadeIn" data-wow-delay="0.1s">
                                <div class="border rounded p-1">
                                    <div class="border rounded text-center p-4">
                                        <i class="fa fa-hotel fa-2x text-primary mb-2"></i>
                                        <h2 class="mb-1" data-toggle="counter-up"><?= $count_rooms ?></h2>
                                        <p class="mb-0">Rooms</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-4 wow fadeIn" data-wow-delay="0.3s">
                                <div class="border rounded p-1">
                                    <div class="border rounded text-center p-4">
                                        <i class="fa fa-users-cog fa-2x text-primary mb-2"></i>
                                        <h2 class="mb-1" data-toggle="counter-up">34</h2>
                                        <p class="mb-0">Staffs</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-4 wow fadeIn" data-wow-delay="0.5s">
                                <div class="border rounded p-1">
                                    <div class="border rounded text-center p-4">
                                        <i class="fa fa-users fa-2x text-primary mb-2"></i>
                                        <h2 class="mb-1" data-toggle="counter-up">1234</h2>
                                        <p class="mb-0">Clients</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <a class="btn btn-primary py-3 px-5 mt-2" href="service">Explore More</a>
                    </div>
                    <div class="col-lg-6">
                        <div class="row g-3">
                            <div class="col-6 text-end">
                                <img class="img-fluid rounded w-75 wow zoomIn" data-wow-delay="0.1s" src="img/about-1.jpg" style="margin-top: 25%;">
                            </div>
                            <div class="col-6 text-start">
                                <img class="img-fluid rounded w-100 wow zoomIn" data-wow-delay="0.3s" src="img/about-2.jpg">
                            </div>
                            <div class="col-6 text-end">
                                <img class="img-fluid rounded w-50 wow zoomIn" data-wow-delay="0.5s" src="img/about-3.jpg">
                            </div>
                            <div class="col-6 text-start">
                                <img class="img-fluid rounded w-75 wow zoomIn" data-wow-delay="0.7s" src="img/about-4.jpg">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- About End -->


        <!-- Room Start -->
        <div class="container-xxl py-5">
            <div class="container">
                <div class="text-center wow fadeInUp" data-wow-delay="0.1s">
                    <h6 class="section-title text-center text-primary text-uppercase">Our Rooms</h6>
                    <h1 class="mb-5">Explore Our <span class="text-primary text-uppercase">Rooms</span></h1>
                </div>
                <div class="row g-4">

                <?php
        
                    
                    while($room = mysqli_fetch_assoc($select_hotel_rooms_result)){

                        $room_id = $room["id"];
                        $room_title = $room["room_title"];
                        $room_prices = $room["room_price"];
                        $no_beds = $room["no_beds"];
                        $no_baths = $room["no_baths"];
                        $adult = $room["adult"];
                        $kids = $room["kids"];
                        $wifi = $room["wifi"];
                        $status = $room["status"];
                        $room_descriptions = $room["room_description"];
                        $room_code = $room["room_code"];
                        $room_no = $room["room_no"];
                        $is_reserved = $room["is_reserved"];
                        $main_image = $room["main_image"];

                        $room_price = number_format($room_prices, 0, '.', ',');

                        $room_description = limitWords($room_descriptions, 20, "...");



                        // To set defult timezone
                        date_default_timezone_set("Africa/Douala");

                        $time_now = date( 'm/d/Y h:i A');

                        // Convert user input dates to UNIX timestamp for easier comparison
                        $user_checkin_timestamp = strtotime($time_now);
                        $user_checkout_timestamp = strtotime($time_now);

                        // Fetch existing reservations for the room from the database
                        $sql = "SELECT checkin, checkout FROM reservations WHERE room_code = ?";
                        $stmt = $conn->prepare($sql);
                        $stmt->bind_param("i", $room_code);
                        $stmt->execute();
                        $result = $stmt->get_result();

                        // Check for overlap with existing reservations
                        $room_available = true;
                        while ($row = $result->fetch_assoc()) {
                            $existing_checkin_timestamp = strtotime($row['checkin']);
                            $existing_checkout_timestamp = strtotime($row['checkout']);
                            
                            // Check for overlap
                            if (
                                ($user_checkin_timestamp < $existing_checkout_timestamp && $user_checkout_timestamp > $existing_checkin_timestamp)
                                || ($user_checkin_timestamp == $existing_checkout_timestamp && $user_checkout_timestamp == $existing_checkin_timestamp)
                            ) {
                                $room_available = false;
                                break;
                            }
                        }

                        if ($room_available) {
                            $is_available = "yes" ;
                        }else{
                            $is_available = "no" ;
                        }


                        $ratings = "SELECT * FROM ratings WHERE room_code = $room_code " ;
                        $q = mysqli_query($conn, $ratings) ;
                        $r_results = mysqli_fetch_assoc($q);
                        $count_rating = mysqli_num_rows($q);

                        // getting the sum
                        $qrys = "SELECT SUM(rate) FROM ratings WHERE room_code =  $room_code";
                        $sumRate = $temp_db->prepare($qrys);
                        $sumRate->execute();
                        $sumResults = $sumRate->fetch(PDO::FETCH_ASSOC);
                        $roomRate = $sumResults['SUM(rate)'];


                        if($count_rating != 0){
                            // Calculating to know avarage review   
                            $avgRating = $roomRate / $count_rating;
                        
                            $roundUp = round($avgRating); // Rounding value to a whole number
                        
                        }else{
                            $roundUp = 0; // Rounding value to a whole number
                        }

                ?>

                    <div class="col-lg-4 col-md-6 wow fadeInUp" data-wow-delay="0.1s">
                        <div class="room-item shadow rounded overflow-hidden">
                            <div class="position-relative">
                                <img class="img-fluid" src="admin/img/hotel_rooms/<?= $main_image ?>" alt="" style="width:500px; height:200px; object-fit:cover">
                                <small class="position-absolute start-0 top-100 translate-middle-y bg-primary text-white rounded py-1 px-3 ms-4">CFA <?= $room_price ?>/Night</small>
                                <?php

                                    if($is_available == "no"){
                                ?>
                                    <small class=" start-0 top-100 translate-middle-y text-white rounded py-1 px-3 ms-4" style="float:right; margin-right: 24px; background-color: #fe1616 !important;">Not Available Today</small>
                                <?php }else{?>
                                    <small class=" start-0 top-100 translate-middle-y text-white rounded py-1 px-3 ms-4" style="float:right; margin-right: 24px; background-color: #00c10f !important;">Available Today</small>
                                <?php }?>
                            </div>
                            <div class="p-4 mt-2">
                                <div class="d-flex justify-content-between mb-3">
                                    <h5 class="mb-0"><?= $room_title ?></h5>
                                    <?php
                                if($roundUp == 5){
                                ?>
                                    <div class="ps-2">
                                        <small class="fa fa-star text-primary"></small>
                                        <small class="fa fa-star text-primary"></small>
                                        <small class="fa fa-star text-primary"></small>
                                        <small class="fa fa-star text-primary"></small>
                                        <small class="fa fa-star text-primary"></small>
                                        <?= $roundUp ?>/5
                                    </div>
                                <?php }elseif($roundUp == 4){?>   
                                    <div class="ps-2">
                                        <small class="fa fa-star text-primary"></small>
                                        <small class="fa fa-star text-primary"></small>
                                        <small class="fa fa-star text-primary"></small>
                                        <small class="fa fa-star text-primary"></small>
                                        <small class="fa fa-star "></small>
                                        <?= $roundUp ?>/5
                                    </div>
                                <?php }elseif($roundUp == 3){?>   
                                    <div class="ps-2">
                                        <small class="fa fa-star text-primary"></small>
                                        <small class="fa fa-star text-primary"></small>
                                        <small class="fa fa-star text-primary"></small>
                                        <small class="fa fa-star "></small>
                                        <small class="fa fa-star "></small>
                                        <?= $roundUp ?>/5
                                    </div>
                                <?php }elseif($roundUp == 2){?>   
                                    <div class="ps-2">
                                        <small class="fa fa-star text-primary"></small>
                                        <small class="fa fa-star text-primary"></small>
                                        <small class="fa fa-star "></small>
                                        <small class="fa fa-star "></small>
                                        <small class="fa fa-star "></small>
                                        <?= $roundUp ?>/5
                                    </div>
                                    <?php }elseif($roundUp == 1){?>   
                                <div class="ps-2">
                                        <small class="fa fa-star text-primary"></small>
                                        <small class="fa fa-star "></small>
                                        <small class="fa fa-star "></small>
                                        <small class="fa fa-star "></small>
                                        <small class="fa fa-star "></small>
                                        <?= $roundUp ?>/5
                                    </div>
                                    <?php }else{ ?>
                                <div class="ps-2">
                                    <small class="fa fa-star "></small>
                                    <small class="fa fa-star "></small>
                                    <small class="fa fa-star "></small>
                                    <small class="fa fa-star "></small>
                                    <small class="fa fa-star "></small>
                                    <?= $roundUp ?>/5
                                </div>
                                <?php }?>  
                                </div>
                                <div class="d-flex mb-3">
                                    <small class="border-end me-3 pe-3"><i class="fa fa-bed text-primary me-2"></i><?= $no_beds ?> Bed</small>
                                    <small class="border-end me-3 pe-3"><i class="fa fa-bath text-primary me-2"></i><?= $no_baths ?> Bath</small>
                                    <?php

                                        if($wifi == 1){
                                    ?>
                                        <small><i class="fa fa-wifi text-primary me-2"></i>Wifi</small>
                                    <?php }?>
                                </div>
                                <p class="text-body mb-3"><?= $room_description ?></p>
                                <div class="d-flex justify-content-between">
                                    <a class="btn btn-sm btn-primary rounded py-2 px-4" href="view?room=<?= $room_code ;?>">View Detail</a>
                                    <a class="btn btn-sm btn-dark rounded py-2 px-4" href="view?room=<?= $room_code ;?>#booking">Book Now</a>
                                </div>
                            </div>
                        </div>
                    </div>

                <?php }
                
                    $number_of_rooms = mysqli_num_rows($select_hotel_rooms_result) ;

                    if($number_of_rooms > 6){
                ?>
                    <a class="btn btn-sm btn-dark rounded py-2 px-4 wow fadeInUp" href="room">More Rooms</a>
                <?php } ?>
                    
                </div>
            </div>
        </div>
        <!-- Room End -->


        <!-- Video Start -->
        <div class="container-xxl py-5 px-0 wow zoomIn" data-wow-delay="0.1s">
            <div class="row g-0">
                <div class="col-md-6 bg-dark d-flex align-items-center">
                    <div class="p-5">
                        <h6 class="section-title text-start text-white text-uppercase mb-3">Luxury Living</h6>
                        <h1 class="text-white mb-4">Discover A Brand Luxurious Hotel</h1>
                        <p class="text-white mb-4">Step into a realm of refined luxury at Holiday Inn Resort Limbe. With exquisite craftsmanship and unparalleled hospitality, our lavish accommodations promise an unforgettable experience. Indulge in serene retreats, culinary delights, and personalized service, all within an ambiance of sophistication. Unveil the allure of unparalleled luxury and embark on an extraordinary journey with us.</p>
                        <a href="room" class="btn btn-primary py-md-3 px-md-5 me-3">Our Rooms</a>
                        <a href="booking" class="btn btn-light py-md-3 px-md-5">Book A Room</a>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="video">
                        <button type="button" class="btn-play" data-bs-toggle="modal" data-src="https://www.youtube.com/" data-bs-target="#videoModal">
                            <span></span>
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="videoModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content rounded-0">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Youtube Video</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <!-- 16:9 aspect ratio -->
                        <div class="ratio ratio-16x9">
                            <iframe class="embed-responsive-item" src="" id="video" allowfullscreen allowscriptaccess="always"
                                allow="autoplay"></iframe>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Video Start -->


        <!-- Service Start -->
        <div class="container-xxl py-5" id="services">
            <div class="container">
                <div class="text-center wow fadeInUp" data-wow-delay="0.1s">
                    <h6 class="section-title text-center text-primary text-uppercase">Our Services</h6>
                    <h1 class="mb-5">Explore Our <span class="text-primary text-uppercase">Services</span></h1>
                </div>
                <div class="row g-4">
                    <div class="col-lg-4 col-md-6 wow fadeInUp" data-wow-delay="0.1s">
                        <a class="service-item rounded" href="">
                            <div class="service-icon bg-transparent border rounded p-1">
                                <div class="w-100 h-100 border rounded d-flex align-items-center justify-content-center">
                                    <i class="fa fa-hotel fa-2x text-primary"></i>
                                </div>
                            </div>
                            <h5 class="mb-3">Rooms & Appartment</h5>
                            <p class="text-body mb-0">Immerse yourself in unparalleled comfort and elegance with our meticulously designed rooms and apartments, each offering a sanctuary of tranquility and sophistication.</p>
                        </a>
                    </div>
                    <div class="col-lg-4 col-md-6 wow fadeInUp" data-wow-delay="0.2s">
                        <a class="service-item rounded" href="">
                            <div class="service-icon bg-transparent border rounded p-1">
                                <div class="w-100 h-100 border rounded d-flex align-items-center justify-content-center">
                                    <i class="fa fa-utensils fa-2x text-primary"></i>
                                </div>
                            </div>
                            <h5 class="mb-3">Food & Restaurant</h5>
                            <p class="text-body mb-0">Delight your palate with a culinary journey like no other at our exquisite restaurant, where every dish is crafted with the finest ingredients and served with a touch of culinary artistry.</p>
                        </a>
                    </div>
                    <div class="col-lg-4 col-md-6 wow fadeInUp" data-wow-delay="0.3s">
                        <a class="service-item rounded" href="">
                            <div class="service-icon bg-transparent border rounded p-1">
                                <div class="w-100 h-100 border rounded d-flex align-items-center justify-content-center">
                                    <i class="fa fa-spa fa-2x text-primary"></i>
                                </div>
                            </div>
                            <h5 class="mb-3">Spa & Fitness</h5>
                            <p class="text-body mb-0">Renew your mind, body, and spirit at our rejuvenating spa and fitness center, where expert therapists and state-of-the-art facilities combine to provide a sanctuary for relaxation and wellness.</p>
                        </a>
                    </div>
                    <div class="col-lg-4 col-md-6 wow fadeInUp" data-wow-delay="0.4s">
                        <a class="service-item rounded" href="">
                            <div class="service-icon bg-transparent border rounded p-1">
                                <div class="w-100 h-100 border rounded d-flex align-items-center justify-content-center">
                                    <i class="fa fa-swimmer fa-2x text-primary"></i>
                                </div>
                            </div>
                            <h5 class="mb-3">Sports & Gaming</h5>
                            <p class="text-body mb-0">Experience the thrill of friendly competition and exhilarating entertainment at our sports and gaming facilities, offering a variety of activities to engage guests of all ages and interests.</p>
                        </a>
                    </div>
                    <div class="col-lg-4 col-md-6 wow fadeInUp" data-wow-delay="0.5s">
                        <a class="service-item rounded" href="">
                            <div class="service-icon bg-transparent border rounded p-1">
                                <div class="w-100 h-100 border rounded d-flex align-items-center justify-content-center">
                                    <i class="fa fa-glass-cheers fa-2x text-primary"></i>
                                </div>
                            </div>
                            <h5 class="mb-3">Event & Party</h5>
                            <p class="text-body mb-0">Celebrate life's special moments in style at our elegant event venues, where impeccable service, exquisite cuisine, and stunning surroundings come together to create unforgettable memories.</p>
                        </a>
                    </div>
                    <div class="col-lg-4 col-md-6 wow fadeInUp" data-wow-delay="0.6s">
                        <a class="service-item rounded" href="">
                            <div class="service-icon bg-transparent border rounded p-1">
                                <div class="w-100 h-100 border rounded d-flex align-items-center justify-content-center">
                                    <i class="fa fa-dumbbell fa-2x text-primary"></i>
                                </div>
                            </div>
                            <h5 class="mb-3">GYM & Yoga</h5>
                            <p class="text-body mb-0">Elevate your fitness journey with our cutting-edge gym and tranquil yoga sessions, designed to inspire balance, strength, and inner peace amidst the hustle and bustle of daily life.</p>
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <!-- Service End -->


        <!-- Testimonial Start -->
        <div class="container-xxl testimonial my-5 py-5 bg-dark wow zoomIn" data-wow-delay="0.1s">
            <div class="container">
                <div class="owl-carousel testimonial-carousel py-5">
                    <div class="testimonial-item position-relative bg-white rounded overflow-hidden">
                        <p>A truly unforgettable stay! From the luxurious accommodations to the impeccable service, every moment at Discover A Brand Luxurious Hotel was a delight. The attention to detail and personalized touches made us feel like royalty. Can't wait to return!</p>
                        <div class="d-flex align-items-center">
                            <img class="img-fluid flex-shrink-0 rounded" src="img/testimonial-1.jpg" style="width: 45px; height: 45px;">
                            <div class="ps-3">
                                <h6 class="fw-bold mb-1">Bar. John Anthony</h6>
                                <small>Lawyer</small>
                            </div>
                        </div>
                        <i class="fa fa-quote-right fa-3x text-primary position-absolute end-0 bottom-0 me-4 mb-n1"></i>
                    </div>
                    <div class="testimonial-item position-relative bg-white rounded overflow-hidden">
                        <p>An oasis of tranquility in the heart of the city! The serene ambiance, coupled with the top-notch amenities, made our stay at Discover A Brand Luxurious Hotel a truly rejuvenating experience. Highly recommended for anyone seeking a peaceful retreat.</p>
                        <div class="d-flex align-items-center">
                            <img class="img-fluid flex-shrink-0 rounded" src="img/testimonial-2.jpg" style="width: 45px; height: 45px;">
                            <div class="ps-3">
                                <h6 class="fw-bold mb-1">Mr Neba Clinton</h6>
                                <small>Accountant</small>
                            </div>
                        </div>
                        <i class="fa fa-quote-right fa-3x text-primary position-absolute end-0 bottom-0 me-4 mb-n1"></i>
                    </div>
                    <div class="testimonial-item position-relative bg-white rounded overflow-hidden">
                        <p>Exceptional hospitality at its finest! From the warm welcome upon arrival to the friendly smiles of the staff throughout our stay, every interaction at Discover A Brand Luxurious Hotel was a pleasure. We felt pampered and cared for from beginning to end.</p>
                        <div class="d-flex align-items-center">
                            <img class="img-fluid flex-shrink-0 rounded" src="img/testimonial-3.jpg" style="width: 45px; height: 45px;">
                            <div class="ps-3">
                                <h6 class="fw-bold mb-1">Mme Julitte Nicole</h6>
                                <small>Business</small>
                            </div>
                        </div>
                        <i class="fa fa-quote-right fa-3x text-primary position-absolute end-0 bottom-0 me-4 mb-n1"></i>
                    </div>
                </div>
            </div>
        </div>
        <!-- Testimonial End -->


        <!-- Team Start -->
        <!-- <div class="container-xxl py-5">
            <div class="container">
                <div class="text-center wow fadeInUp" data-wow-delay="0.1s">
                    <h6 class="section-title text-center text-primary text-uppercase">Our Team</h6>
                    <h1 class="mb-5">Explore Our <span class="text-primary text-uppercase">Staffs</span></h1>
                </div>
                <div class="row g-4">
                    <div class="col-lg-3 col-md-6 wow fadeInUp" data-wow-delay="0.1s">
                        <div class="rounded shadow overflow-hidden">
                            <div class="position-relative">
                                <img class="img-fluid" src="img/team-1.jpg" alt="">
                                <div class="position-absolute start-50 top-100 translate-middle d-flex align-items-center">
                                    <a class="btn btn-square btn-primary mx-1" href=""><i class="fab fa-facebook-f"></i></a>
                                    <a class="btn btn-square btn-primary mx-1" href=""><i class="fab fa-twitter"></i></a>
                                    <a class="btn btn-square btn-primary mx-1" href=""><i class="fab fa-instagram"></i></a>
                                </div>
                            </div>
                            <div class="text-center p-4 mt-3">
                                <h5 class="fw-bold mb-0">Full Name</h5>
                                <small>Designation</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6 wow fadeInUp" data-wow-delay="0.3s">
                        <div class="rounded shadow overflow-hidden">
                            <div class="position-relative">
                                <img class="img-fluid" src="img/team-2.jpg" alt="">
                                <div class="position-absolute start-50 top-100 translate-middle d-flex align-items-center">
                                    <a class="btn btn-square btn-primary mx-1" href=""><i class="fab fa-facebook-f"></i></a>
                                    <a class="btn btn-square btn-primary mx-1" href=""><i class="fab fa-twitter"></i></a>
                                    <a class="btn btn-square btn-primary mx-1" href=""><i class="fab fa-instagram"></i></a>
                                </div>
                            </div>
                            <div class="text-center p-4 mt-3">
                                <h5 class="fw-bold mb-0">Full Name</h5>
                                <small>Designation</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6 wow fadeInUp" data-wow-delay="0.5s">
                        <div class="rounded shadow overflow-hidden">
                            <div class="position-relative">
                                <img class="img-fluid" src="img/team-3.jpg" alt="">
                                <div class="position-absolute start-50 top-100 translate-middle d-flex align-items-center">
                                    <a class="btn btn-square btn-primary mx-1" href=""><i class="fab fa-facebook-f"></i></a>
                                    <a class="btn btn-square btn-primary mx-1" href=""><i class="fab fa-twitter"></i></a>
                                    <a class="btn btn-square btn-primary mx-1" href=""><i class="fab fa-instagram"></i></a>
                                </div>
                            </div>
                            <div class="text-center p-4 mt-3">
                                <h5 class="fw-bold mb-0">Full Name</h5>
                                <small>Designation</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6 wow fadeInUp" data-wow-delay="0.7s">
                        <div class="rounded shadow overflow-hidden">
                            <div class="position-relative">
                                <img class="img-fluid" src="img/team-4.jpg" alt="">
                                <div class="position-absolute start-50 top-100 translate-middle d-flex align-items-center">
                                    <a class="btn btn-square btn-primary mx-1" href=""><i class="fab fa-facebook-f"></i></a>
                                    <a class="btn btn-square btn-primary mx-1" href=""><i class="fab fa-twitter"></i></a>
                                    <a class="btn btn-square btn-primary mx-1" href=""><i class="fab fa-instagram"></i></a>
                                </div>
                            </div>
                            <div class="text-center p-4 mt-3">
                                <h5 class="fw-bold mb-0">Full Name</h5>
                                <small>Designation</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div> -->
        <!-- Team End -->

        

<?php

    include "includes/footer.php";

?>