<?php

include "database/config.php";
include "includes/head.php";
include "includes/navbar.php";

//error_reporting(0);

?>
        <!-- Page Header Start -->
        <div class="container-fluid page-header mb-5 p-0" style="background-image: url(img/flower_bg.jpg);">
            <div class="container-fluid page-header-inner py-5">
                <div class="container text-center pb-5">
                    <h1 class="display-3 text-white mb-3 animated slideInDown">Founder's Obituary</h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb justify-content-center text-uppercase">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item"><a href="#">About</a></li>
                            <li class="breadcrumb-item text-white active" aria-current="page">Obituary</li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
        <!-- Page Header End -->


        <!-- Booking Start -->
        <div class="container-fluid booking pb-5 wow fadeIn" data-wow-delay="0.1s">
            <div class="container">
                <div class="bg-white shadow" style="padding: 35px;">
                    <h6 class="section-title text-start text-primary text-uppercase">Write a </h6>
                    <h1 class="mb-4">Fairwell <span class="text-primary text-uppercase"> Wish</span></h1>
                    <div class="row g-2">
                        <div class="col-md-10">
                            <div class="row g-2">
                                <div class="col-md-3">
                                    <input type="file" class="form-control datetimepicker-input" id="profile" />
                                </div>
                                <div class="col-md-2">
                                    <div class="date" id="date1" data-target-input="nearest">
                                        <input type="text" class="form-control datetimepicker-input" id="name" placeholder="Name" value="" />
                                        <span class="text-danger" id="name_required" style="display:none">Name is required</span>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="date" id="date2" data-target-input="nearest">
                                        <select class="form-select" id="relation">
                                            <option value="" >Select Relationship</option>
                                            <option value="Son">Son</option>
                                            <option value="Daughter">Daughter</option>
                                            <option value="Brother">Brother</option>
                                            <option value="sister">sister</option>
                                            <option value="Grand Son">Grand Son</option>
                                            <option value="Grand Daughter">Grand Daughter</option>
                                            <option value="Employee">Employee</option>
                                            <option value="Friend">Friend</option>
                                            <option value="In-Law">In-Law</option>
                                            <option value="Collegue">Collegue</option>
                                            <option value="Well Wisher">Customer</option>
                                            <option value="Well Wisher">Well Wisher</option>
                                        </select>
                                        <span class="text-danger" id="relation_required" style="display:none">Relation is required</span>
                                    </div>
                                </div>
                                <div class="col-md-5">
                                    <input type="text" class="form-control datetimepicker-input" id="comment" placeholder="Message" />
                                    <span class="text-danger" id="message_required" style="display:none">Message is required</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <button onclick="post()" class="btn btn-primary w-100"><img src="img/loader.gif" alt="" style="width:22px; display:none"> Post</button>
                        </div>
                        <div class="alert alert-success" id="message_success" style="display:none">Message Posted</div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Booking End -->


        <section>
            <div class="row">
                <div class="col col-md-4 comment-section" style="position: sticky; top: 0;">
                    <h6 class="section-title text-start text-primary text-uppercase">Fairwell Wishes</h6>
                    <h1 class="mb-4">To <span class="text-primary text-uppercase"> Barrister Weledji</span></h1>
                    <div class="comments" style="max-height: 566px; overflow-y: auto;">
                        <div id="wishes">
                           
                        </div>
                        
                    </div>
                </div>
                <div class="col col-md-8" style="z-index: 9999; background-color: white;">
                    <div class="mini_nav" style="position: sticky; top: 0;">
                        <a href="#biography"><button class="mini_nav_btn">Biography</button></a>
                        <a href="#eulogies"><button class="mini_nav_btn">Eulogies</button></a>
                        <a href="#gallery"><button class="mini_nav_btn">Gallery</button></a>
                        <a href="#programme"><button class="mini_nav_btn">Funeral Programme</button></a>
                    </div>
                    <!-- About Start -->
                        <div class="container-xxl py-5" id="biography">
                            <div class="container">
                                <div class="row g-5 align-items-center">
                                    <div class="col-lg-12">
                                        <h6 class="section-title text-start text-primary text-uppercase">Biography of</h6>
                                        <h1 class="mb-4">Barrister Mariana <span class="text-primary text-uppercase">Ngunjo Shalo Weledji, (Mafeu Nyosi),</span></h1>
                                        <p class="mb-4">
                                            The life of Mariana Ngunjo Shalo Weledji, lovingly known as Mami Weledji, was remarkable. Born into the Shalo family in Bamenda on 13th December 1937, the eldest child of Papa Raphael Shalo and Mami Elizabeth Yondou, she embodied the spirit of strength and leadership from an early age. Her parents being devoted Catholic Christians, baptized their beloved daughter at birth, at the St Joseph Catholic Church in Mankon, Bamenda as “Mariana.” She was nurtured by the love of her devoted parents, who instilled in her the values of discipline, education, and faith.
                                        </p>
                                        <p>
                                        From her early years in 1944 at St. Joseph Catholic Primary School in Abakwa, Convent school Small Soppo in Buea, she received First Holy Communion in 1947. She completed primary education in 1952 and proceeded to Holy Rosary College in Enugu, Nigeria, and completed in 1955, Mariana's thirst for knowledge and her commitment to her studies were evident. Despite the challenges of her upbringing, facing hardships and responsibilities, including caring for her younger siblings, Mariana excelled academically, and this laid the foundation for her future endeavors. On returning from Nigeria, she was recruited as a Grade 11 primary school teacher.
                                        </p>
                                        <p>
                                        Marriage to Mr. Pancratius Weledji in 1956 in Kumba, marked the beginning of a new chapter in Mariana's life. Their union was soon blessed with 4 lovely children- Mr. Eric Weledji, Professor Patrick Weledji, Mr. Conrad Weledji; Mrs. Evelyne Weledji Ngampi. As a wife, mother, and educator, Mariana Weledji navigated the responsibilities of family life with grace and determination. Her unwavering dedication to her children's education, coupled with her pursuit of further qualifications, demonstrated her relentless pursuit of excellence.
                                        </p>
                                        <p>
                                        Academically, from a Grade II teacher, studying privately for the GCE “O ”and “A” levels mapped her pathways to greater heights. She was awarded a Commonwealth scholarship to study Government at the University of Oxford where she graduated with a Diploma in Administration. During this period, she sat for the Inter LLB examination and passed. From 1966 to June 1968, she enrolled at the Holborn College of Law in London and graduated with an LLB 2nd Class 
                                        Honors, got the BL, and later was called to the Bar of England and Wales, as a member of Gray’s Inn. Subsequently, she was awarded the British International Aid to pursue a Master’s degree program (LL.M). However, the thought of staying away from her young family and four children for much longer was more than she was prepared to concede. Within 6 months into the LL.M course, she decided to return home.
                                        </p>
                                        <p>
                                        Upon her return and after due application, in 1968, Barrister Mrs. Mariana Ngunjo Shalo Weledji was called as a Barrister and Solicitor of the West Cameroon Supreme Court, and her name is Number Two on the current Bar Roll. She later opened the Ngehdee Chambers, her Law firm in Limbe, then Victoria. The name “Ngehdee” was reminiscent of the title by which the girls in her family were known. The family would be further enlarged with the arrival of 2 more children, Edmond Siewe (later deceased) and Terence.
                                        </p>
                                        <p>
                                        Barrister Weledji’s journey into the legal profession was ground-breaking. In a male-dominated field, she fearlessly pursued her passion for justice and equality, becoming the first Cameroonian woman lawyer to be called to the Bar, if not the first in Central Africa. Despite initial skepticism and prejudice, Barrister Weledji’s formidable intellect and unwavering resolve earned her the respect of her peers and the admiration of all who knew her.
                                        </p>
                                        <p>
                                        Beyond her legal career, Barrister Weledji was a trailblazer in community development and by extension, philanthropy. Her entrepreneurial acumen and tireless commitment to social causes transformed the landscape of her community. From founding the International Federation of Women Lawyers (FIDA) Cameroon in 1994 to 2000 to spearheading initiatives for women's empowerment and education, Mariana Weledji’s impact was far-reaching and enduring. Her commitment to promoting the standing and status of women was unquestionable throughout her lifetime. During her tenure as a member of the Cameroon Bar Council in the early 90s, she advocated forcefully for more females to accept active positions of responsibility within the Bar. At pre-university levels, she actively encouraged young Cameroonian girls graduating from High schools like C.C.A.S.T Bambili & Kumba to study law, not just for practice, but to be able to continue to help enlighten and inform the womenfolk.
                                        </p>
                                        <p>
                                        Her commitment to women's empowerment was not limited to the professional arena. During her tenure as maiden President of “Nkoni” (“Love” in the Bamilike dialect), an Association founded 
                                        by Mrs. Elizabeth Mbayu Ngu to preserve the Bamilike culture and traditions in Anglophone Cameroon, Mami Weledji deployed several significant initiatives that would give the Association a significant international dimension. Along with her executive, she made some far-reaching decisions, acquiring acres of land in Kumba for a vocational school for “out-of-school” girls to give them hope for the future. She pushed forward her vision, encouraging and preparing younger women to take over as she prepared to step down in 2008. She was honored with  the title of <b>“Nkam Menzue”</b> meaning “Woman of Dignity.”
                                        </p>
                                        <p>
                                        As one of the founding members of the Lion’s Club, Mami Weledji was a Lion at heart, dedicated to helping the under-privileged in the community. She participated in all fund-raising activities, the proceeds of which were distributed to the Bulu Centre for the Blind, the handicapped Centre in Mutengene, and orphanages within the Region. The Holiday Inn Resort’s (HIR) charitable activities aimed at “giving back to the community” continue to support the refurbishment of the Bulu Blind Centre and provide support for the blind women of Mile 16, near Buea.
                                        </p>
                                        <p>
                                        Her formidable entrepreneurial skills and ability to multitask were admirable. The Weledji Estate (which today includes the HOLIDAY INN RESORT (HIR) and several other properties) was born out of her determination to develop real estate in Limbe a field that she was able to realize without shunning her legal practice nor indeed her multifarious social and community activities.
                                        </p>
                                        <p>
                                        Mami Weledji was also the founder of the Association of Hoteliers (HORAC) in 2006, a platform whereby hotel proprietors and managers could come together and seek solutions to their common problems as well as discuss pathways towards a flourishing tourism industry.
                                        </p>
                                        <p>
                                        A deep-rooted faith was the guiding force in Mariana's life. A devout Catholic, she dedicated herself to serving her parish, diocese, seminary, and beyond, nurturing the spiritual growth of those around her. Over the years she prepared countless children for baptism and the first Holy Communion and she made it her duty to personally supervise the decoration of the church for Sunday mass for as long as her physical condition permitted. Her awe-inspiring devotion to the <b>Divine Mercy Apostolate</b> and her unwavering commitment to prayer and charity reflected her unfathomable connection to her faith and her desire to make a difference in the lives of others.
                                        </p>
                                        <p>
                                        A woman of substance, dignity, and integrity, she was a Board member of the Catholic Universities of Bamenda and Buea, representing the diocese of Buea in the council of CATU from 2010 to 2015. In September 2012, she was also appointed a member of the Catholic University Institute of Buea (CUIB), Board of Trustees, a position she held until 2020 when the Board was dissolved. As a member of the advisory board of CUIB, she played a key role in the rapid growth and diversification initiatives of this University.
                                        </p>
                                        <p>
                                        As a mother, Mami Weledji’s love knew no bounds. Despite facing personal tragedy with the loss of her son Edmond in August 2000, she remained a pillar of strength for her family, ensuring single-handedly that her biological children received the best education she could afford as well as the love and guidance every child cherishes. <b>Her legacy lives on in her four sons, one daughter, her fifteen (15) grandchildren, 1 great-grandchild,</b> her extended family members, and all those whose lives she touched with her kindness, wisdom, and compassion.
                                        </p>
                                        <p>
                                        Mariana Weledji's life was a testament to the power of resilience, determination, and love. Her legacy will continue to inspire generations to come, reminding us of all the difference that one individual can make in the world. Even in her natal village of Fongoli through her great philanthropic actions and building of the St Ralphael Catholic church, she was bestowed the title of <b>“Mafeu Nyosi”</b>- the one who fixes, by the two traditional Chiefs who “brought the palace” to Limbe in 2008 to preside and personally bestow this great honor.
                                        </p>
                                        <p>
                                        Mami Weledji had her nuclear and extended family siblings to whom she remained quite attached, along with their children. She supported most as best she could and endeavoured to be present whenever the need arose. Whether it was the <b>Shalo brothers</b>: Boniface, Jeremiah, Christopher (who predeceased her), Louis, Emmanuel Jacques, Vitus, Valentine, Felix, John, Raphael, and Small Raphael or indeed the <b>Shalo girls</b>: Therese Tchombe (her close friend and confidante to the very end), Josephine Muna, Philomena, Magdalene Tsewele, Florence, Electa Mbianda, Celine, Mary Fonkeng, Gladys Ndasi, Joesphine Fon, and her sis-cousins Ma Martha Afong and Ma  Philomena Simo, the attention and affection were unwavering; that same love 
                                        and concern were extended to her mother Ma Eli of blessed memory, as well as her other “mothers”, Mami Christie, Mami Agie, Mami Julie and Mami Manyi Odette.
                                        </p>
                                        <p>
                                        Along with family, Mami Weledji treasured friendships, sincere friendships-hence her small circle of close friends, despite the significant number of professional and non-professional acquaintances. She particularly enjoyed the company and confidence of Ma Regina Ayamo Oben who, with her husband “Daddy” Thomas Oben had stood firmly by her over the years, particularly during some very trying moments in her life. Their passing some years ago she found particularly hard to come to terms with.
                                        </p>
                                        <p>
                                        If there is one request that Mami Weledji had made which, unfortunately, we as a family could not accede to, it was that upon her passing her mortal remains should be placed in the most basic of caskets (coffins), purchased locally. So, if the casket in which she lies today looks even half-decent, please note that it is 10 times more than what our mother would have wanted or had asked for. Her message to her family, her children, and her grandchildren went along these lines: “There is a candle in every soul------There is a spirit who brings a fire---Hold out your candle for all to see.” Take your candle and go to light the world, as I have tried to do in my time on earth” Thus I am saying: <br>
                                        <ul>
                                            <li>I have endeavored to live my life in the best way possible;</li>
                                            <li>I have faced my challenges as best I could;</li>
                                            <li>I have served my God to the very end;</li>
                                            <li>All we can do now is continue to pray. Pray for yourselves, pray for me. The rest…. is Vanity</li>
                                        </ul>
                                        </p>


                                        <div class="row g-3 pb-4">
                                            <div class="col-sm-4 wow fadeIn" data-wow-delay="0.3s">
                                                <div class="border rounded p-1">
                                                    <div class="border rounded text-center p-4">
                                                        <i class="fa fa-users-cog fa-2x text-primary mb-2"></i>
                                                        <h2 class="mb-1" data-toggle="counter-up">5</h2>
                                                        <p class="mb-0">Children</p>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-4 wow fadeIn" data-wow-delay="0.5s">
                                                <div class="border rounded p-1">
                                                    <div class="border rounded text-center p-4">
                                                        <i class="fa fa-users fa-2x text-primary mb-2"></i>
                                                        <h2 class="mb-1" data-toggle="counter-up">15</h2>
                                                        <p class="mb-0">Grand Children</p>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-4 wow fadeIn" data-wow-delay="0.5s">
                                                <div class="border rounded p-1">
                                                    <div class="border rounded text-center p-4">
                                                        <i class="fa fa-users fa-2x text-primary mb-2"></i>
                                                        <h2 class="mb-1" data-toggle="counter-up">1</h2>
                                                        <p class="mb-0">Great Grand Children</p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- <a class="btn btn-primary py-3 px-5 mt-2" href="">Explore More</a> -->
                                    </div>
                                    <!-- <div class="col-lg-6">
                                        <img class="img-fluid rounded w-75 wow zoomIn" data-wow-delay="0.1s" src="img/weledji_1.jpg" style="margin-top: 25%;">
                                    </div> -->
                                </div>
                            </div>
                        </div>
                        <!-- About End -->


                        <!-- Team Start -->
                        <div class="container-xxl py-5" id="eulogies">
                            <div class="container">
                                <div class="text-center wow fadeInUp" data-wow-delay="0.1s">
                                    <h6 class="section-title text-center text-primary text-uppercase">Our Lovely Mother</h6>
                                    <h1 class="mb-5">Children's <span class="text-primary text-uppercase">Eulogy</span></h1>
                                </div>

                            <?php 
                                $select_eulogies = "SELECT * FROM eologies";
                                $select_eulogies_result = mysqli_query($conn, $select_eulogies);
                                while($eulogies = mysqli_fetch_assoc($select_eulogies_result)){

                                    $id = $eulogies["id"];
                                    $name = $eulogies["name"];
                                    $relation = $eulogies["relation"];
                                    $time = $eulogies["time"];
                                    $profile = $eulogies["profile"];
                                    $date = $eulogies["time"];
                                    $text = $eulogies["text"];
                            ?>

                                <div class="row g-4" style="margin-bottom:10px; background-color: #fea11624; padding: 12px; border-radius: 20px; ">
                                    <div class="col-lg-3 col-md-6 wow fadeInUp" data-wow-delay="0.1s">
                                        <div class="rounded shadow overflow-hidden">
                                            <div class="position-relative">
                                                <img class="img-fluid" src="img/profiles/<?= $profile ?>" alt="" style="width:170px; height:170px; object-fit:cover">
                                                <!-- <div class="position-absolute start-50 top-100 translate-middle d-flex align-items-center">
                                                    <a class="btn btn-square btn-primary mx-1" href=""><i class="fab fa-facebook-f"></i></a>
                                                    <a class="btn btn-square btn-primary mx-1" href=""><i class="fab fa-twitter"></i></a>
                                                    <a class="btn btn-square btn-primary mx-1" href=""><i class="fab fa-instagram"></i></a>
                                                </div> -->
                                            </div>
                                            <div class="text-center" style="padding:10px">
                                                <h5 class="fw-bold mb-0"><?= $name ?></h5>
                                                <small><?= $relation ?></small>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-9 col-md-6 wow fadeInUp" data-wow-delay="0.3s">
                                        <p><?= $text ?></p>
                                        <h6 class="section-title text-start text-primary text-uppercase"><?= $name ?></h6>
                                    </div>
                                </div>
                                <br>

                            <?php } ?>
                                

                                
                            </div>
                        </div>
                        <!-- Team End -->
                        
                        <br><br>
                        <div class="" id="gallery">
                            <div class="text-center wow fadeInUp" data-wow-delay="0.1s">
                                <h6 class="section-title text-center text-primary text-uppercase">Our Lovely </h6>
                                <h1 class="mb-5">Mother's <span class="text-primary text-uppercase">Gallery</span></h1>
                            </div>
                            <div class="gallery">
                                <div class="lightbox-overlay">
                                        <button class="prev-button"><</button>
                                    <div class="lightbox-container">
                                        <button class="close-button">X</button>
                                        <img class="lightbox-image" src="" alt="">
                                    </div>
                                        <button class="next-button">></button>
                                </div>
                                <div class="thumbnails-container"></div>
                            </div>
                        </div>



                        <br><br>
                        <br><br>
                        <div style="background-color: #0f172b14; padding: 15px; border-radius: 20px; " id="programme">
                            <div class="text-center wow fadeInUp" data-wow-delay="0.1s">
                                <h6 class="section-title text-center text-primary text-uppercase">Dr. Weledji's</h6>
                                <h1 class="mb-5">Funeral <span class="text-primary text-uppercase">Programme</span></h1>
                            </div>
                            <div class="funeral_program">
                                <img src="img/funeral_prog.jpg" alt="" style="width:100%; border-radius:20px">
                                <br><br> <br> 
                                <table id="table" class="table table-striped ">
                                    <thead>
                                        <tr>
                                            <th>Day</th>
                                            <th>Time</th>
                                            <th>Location</th>
                                            <th>Narration</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    <?php 
                                        $select_programme = "SELECT * FROM programme";
                                        $select_programme_result = mysqli_query($conn, $select_programme);
                                        while($programme = mysqli_fetch_assoc($select_programme_result)){

                                            $id = $programme["id"];
                                            $date = $programme["date"];
                                            $time = $programme["time"];
                                            $location = $programme["location"];
                                            $narration = $programme["narration"];

                                            $new_date = date('l, F j, Y', strtotime($date));
                                    ?>
                                            <tr>
                                                <td><?= $new_date ?></td>
                                                <td><?= $time ?></td>
                                                <td><?= $location ?></td>
                                                <td><?= $narration ?></td>
                                                
                                            </tr>

                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>


                </div> <!-- End -->
                
            </div>
        </section>





        <script>
           document.addEventListener("DOMContentLoaded", function() {
            const lightboxOverlay = document.querySelector('.lightbox-overlay');
            const lightboxImage = document.querySelector('.lightbox-image');
            const thumbnailsContainer = document.querySelector('.thumbnails-container');
            const prevButton = document.querySelector('.prev-button');
            const nextButton = document.querySelector('.next-button');
            const closeButton = document.querySelector('.close-button');

            let imageNames = []; // Array to store image filenames from the database
            let currentIndex = 0;

            // Fetch image filenames from the database
            fetchImageNames();

            function fetchImageNames() {
                fetch('fetch_images.php')
                .then(response => response.json())
                .then(data => {
                    imageNames = data;
                    renderThumbnails();
                })
                .catch(error => console.error('Error fetching image names:', error));
            }

            function renderThumbnails() {
                thumbnailsContainer.innerHTML = '';
                imageNames.forEach((imageName, index) => {
                const thumbnail = document.createElement('img');
                thumbnail.src = `img/gallery/${imageName}`; // Assuming images are stored in 'images/' folder
                thumbnail.alt = `Thumbnail ${index + 1}`;
                thumbnail.addEventListener('click', () => openLightbox(index));
                thumbnailsContainer.appendChild(thumbnail);
                });
            }

            function openLightbox(index) {
                currentIndex = index;
                lightboxImage.src = `img/gallery/${imageNames[index]}`; // Assuming images are stored in 'images/' folder
                lightboxOverlay.style.display = 'flex';
            }

            function closeLightbox() {
                lightboxOverlay.style.display = 'none';
            }

            function showNextImage() {
                currentIndex = (currentIndex + 1) % imageNames.length;
                lightboxImage.src = `img/gallery/${imageNames[currentIndex]}`; // Assuming images are stored in 'images/' folder
            }

            function showPrevImage() {
                currentIndex = (currentIndex - 1 + imageNames.length) % imageNames.length;
                lightboxImage.src = `img/gallery/${imageNames[currentIndex]}`; // Assuming images are stored in 'images/' folder
            }

            // Event listeners
            prevButton.addEventListener('click', showPrevImage);
            nextButton.addEventListener('click', showNextImage);
            closeButton.addEventListener('click', closeLightbox);

            // Close lightbox when clicking outside the image
            lightboxOverlay.addEventListener('click', event => {
                if (event.target === lightboxOverlay) {
                closeLightbox();
                }
            });

            // Keyboard navigation
            document.addEventListener('keydown', event => {
                if (event.key === 'Escape') {
                closeLightbox();
                } else if (event.key === 'ArrowLeft') {
                showPrevImage();
                } else if (event.key === 'ArrowRight') {
                showNextImage();
                }
            });
            });



        </script>




        <script>
            function post(){
                var name = $("#name").val();
                var relation = $("#relation").val();
                var comment = $("#comment").val();
                var file_data = $('#profile').prop('files')[0];    //Fetch the file
                var form_data = new FormData();
                form_data.append("file",file_data);
                form_data.append("name",name);
                form_data.append("relation",relation);
                form_data.append("comment",comment);

                //alert(name);

                if(name == ""){
                    $("#name_required").show();
                }else if(relation == ""){
                    $("#relation_required").show();
                }else if(comment == ""){
                    $("#message_required").show();
                }else{
                    //Ajax to send file to upload
                    $.ajax({
                        url: "api/post_fairwell",   //Server api to receive the file
                        type: "POST",
                        dataType: 'script',
                        cache: false,
                        contentType: false,
                        processData: false,
                        data: form_data,
                        beforeSend: () => {
                        $("#loader").show();
                        },
                        complete: () => {
                            $("#loader").hide();
                        },
                        success:function(response){
                            data = response.trim();
                            if(data == "ok"){
                                $("#message_success").show()
                            }else{
                                alert("Error:: Please try again")
                            }
                            
                        }
                    });
                }
            }


            // Declare a variable to hold the interval ID
            var intervalID;

            // Function to start fetching messages and scrolling
            function startFetchingAndScrolling() {
                // Start the interval
                intervalID = setInterval(fetchWishesAndScroll, 200);
            }

            // Function to fetch wishes and handle scrolling
            function fetchWishesAndScroll() {
                // Save the current scroll position
                var isAtBottom = isChatAtBottom();

                // Fetch wishes
                $.ajax({
                    url: "api/fetch_wishes",
                    method: "POST",
                    success: function(data) {
                        $('#wishes').html(data);
                        
                        // If the user was at the bottom, scroll down
                        if (isAtBottom) {
                            scrollChatToBottom();
                        }
                    }
                });
            }

            // Function to check if the chat container is scrolled to the bottom
            function isChatAtBottom() {
                var chatContainer = document.querySelector('.comments');
                return chatContainer.scrollHeight - chatContainer.clientHeight <= chatContainer.scrollTop + 1;
            }

            // Function to scroll chat container to bottom
            function scrollChatToBottom() {
                var chatContainer = document.querySelector('.comments');
                chatContainer.scrollTop = chatContainer.scrollHeight;
            }

            // Event listener for page load
            document.addEventListener('DOMContentLoaded', function () {
                // Start fetching and scrolling
                startFetchingAndScrolling();

                // Event listener for when the user clicks on a link
                document.querySelectorAll('a[href^="#"]').forEach(anchor => {
                    anchor.addEventListener('click', function (e) {
                        // Clear the interval when the user clicks on a link
                        clearInterval(intervalID);
                        // Resume fetching and scrolling after a short delay (e.g., 500 milliseconds)
                        setTimeout(startFetchingAndScrolling, 500);
                    });
                });
            });







            // Function to fetch wishes and handle scrolling
            function fetchWishesAndScroll() {
                // Save the current scroll position
                var isAtBottom = isChatAtBottom();

                // Fetch wishes
                $.ajax({
                    url: "api/fetch_wishes",
                    method: "POST",
                    success: function(data) {
                        $('#wishes').html(data);
                        
                        // If the user was at the bottom, scroll down
                        if (isAtBottom) {
                            scrollChatToBottom();
                        }
                    }
                });
            }

            // Function to check if the chat container is scrolled to the bottom
            function isChatAtBottom() {
                var chatContainer = document.querySelector('.comments');
                return chatContainer.scrollHeight - chatContainer.clientHeight <= chatContainer.scrollTop + 1;
            }

            // Function to scroll chat container to bottom
            function scrollChatToBottom() {
                var chatContainer = document.querySelector('.comments');
                chatContainer.scrollTop = chatContainer.scrollHeight;
            }


        </script>
        
<?php

    include "includes/footer.php";

?>