<?php

include "database/config.php";
include "database/temp_db.php";
include "includes/head.php";
include "includes/navbar.php";

function limitWords($string, $word_limit) {
    // Split the string into an array of words
    $words = explode(' ', $string);
    
    // Check if the number of words is less than or equal to the limit
    if (count($words) <= $word_limit) {
        // If yes, return the original string
        return $string;
    }
    
    // Select the first $word_limit words
    $limited_words = array_slice($words, 0, $word_limit);
    
    // Join the words back into a single string
    $limited_string = implode(' ', $limited_words). '...';
    
    return $limited_string;
}

//error_reporting(0);

?>
        <!-- Page Header Start -->
        <div class="container-fluid page-header mb-5 p-0" style="background-image: url(img/carousel-1.jpg);">
            <div class="container-fluid page-header-inner py-5">
                <div class="container text-center pb-5">
                    <h1 class="display-3 text-white mb-3 animated slideInDown">Rooms</h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb justify-content-center text-uppercase">
                            <li class="breadcrumb-item"><a href="./">Home</a></li>
                            <li class="breadcrumb-item"><a href="#">Rooms</a></li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
        <!-- Page Header End -->


        <!-- Booking Start -->
        <div class="container-fluid booking pb-5 wow fadeIn" data-wow-delay="0.1s">
            <div class="container">
                <div class="bg-white shadow" style="padding: 35px;">
                    <form action="search" method="GET">
                        <div class="row g-2">
                            <div class="col-md-10">
                                <div class="row g-2">
                                    <div class="col-md-3">
                                        <div class="date" id="date1" data-target-input="nearest">
                                            <input type="text" class="form-control datetimepicker-input"
                                                placeholder="Check in" name="checkin" data-target="#date1" data-toggle="datetimepicker" />
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="date" id="date2" data-target-input="nearest">
                                            <input type="text" class="form-control datetimepicker-input" name="checkout" placeholder="Check out" data-target="#date2" data-toggle="datetimepicker"/>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <select class="form-select" name="adult">
                                            <option selected>Adult</option>
                                            <option value="1">Adult 1</option>
                                            <option value="2">Adult 2</option>
                                            <option value="3">Adult 3</option>
                                            <option value="4">Adult 4</option>
                                            <option value="5">Adult 5</option>
                                            <option value="6">Adult 6</option>
                                        </select>
                                    </div>
                                    <div class="col-md-3">
                                        <select class="form-select" name="kids">
                                            <option selected>Child</option>
                                            <option value="0">No Child</option>
                                            <option value="1">Child 1</option>
                                            <option value="2">Child 2</option>
                                            <option value="3">Child 3</option>
                                            <option value="4">Child 4</option>
                                            <option value="5">Child 5</option>
                                            <option value="6">Child 6</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <button class="btn btn-primary w-100" name="s">Search</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <!-- Booking End -->


        <!-- Room Start -->
        <div class="container-xxl py-5">
            <div class="container">
                <div class="text-center wow fadeInUp" data-wow-delay="0.1s">
                    <h6 class="section-title text-center text-primary text-uppercase">Our Rooms</h6>
                    <h1 class="mb-5">Explore Our <span class="text-primary text-uppercase">Rooms</span></h1>
                </div>
                <div class="row g-4">

                <?php
        
                    $select_hotel_rooms = "SELECT * FROM hotel_rooms WHERE is_delete != 1 ";
                    $select_hotel_rooms_result = mysqli_query($conn, $select_hotel_rooms);
                    while($room = mysqli_fetch_assoc($select_hotel_rooms_result)){

                        $room_id = $room["id"];
                        $room_title = $room["room_title"];
                        $room_prices = $room["room_price"];
                        $no_beds = $room["no_beds"];
                        $no_baths = $room["no_baths"];
                        $adult = $room["adult"];
                        $kids = $room["kids"];
                        $wifi = $room["wifi"];
                        $status = $room["status"];
                        $room_descriptions = $room["room_description"];
                        $room_code = $room["room_code"];
                        $room_no = $room["room_no"];
                        $is_reserved = $room["is_reserved"];
                        $main_image = $room["main_image"];

                        $room_price = number_format($room_prices, 0, '.', ',');

                        $room_description = limitWords($room_descriptions, 20, "...");



                        // To set defult timezone
                        date_default_timezone_set("Africa/Douala");

                        $time_now = date( 'm/d/Y h:i A');

                        // Convert user input dates to UNIX timestamp for easier comparison
                        $user_checkin_timestamp = strtotime($time_now);
                        $user_checkout_timestamp = strtotime($time_now);

                        // Fetch existing reservations for the room from the database
                        $sql = "SELECT checkin, checkout FROM reservations WHERE room_code = ?";
                        $stmt = $conn->prepare($sql);
                        $stmt->bind_param("i", $room_code);
                        $stmt->execute();
                        $result = $stmt->get_result();

                        // Check for overlap with existing reservations
                        $room_available = true;
                        while ($row = $result->fetch_assoc()) {
                            $existing_checkin_timestamp = strtotime($row['checkin']);
                            $existing_checkout_timestamp = strtotime($row['checkout']);
                            
                            // Check for overlap
                            if (
                                ($user_checkin_timestamp < $existing_checkout_timestamp && $user_checkout_timestamp > $existing_checkin_timestamp)
                                || ($user_checkin_timestamp == $existing_checkout_timestamp && $user_checkout_timestamp == $existing_checkin_timestamp)
                            ) {
                                $room_available = false;
                                break;
                            }
                        }

                        if ($room_available) {
                            $is_available = "yes" ;
                        }else{
                            $is_available = "no" ;
                        }


                        $ratings = "SELECT * FROM ratings WHERE room_code = $room_code " ;
                        $q = mysqli_query($conn, $ratings) ;
                        $r_results = mysqli_fetch_assoc($q);
                        $count_rating = mysqli_num_rows($q);

                        // getting the sum
                        $qrys = "SELECT SUM(rate) FROM ratings WHERE room_code =  $room_code";
                        $sumRate = $temp_db->prepare($qrys);
                        $sumRate->execute();
                        $sumResults = $sumRate->fetch(PDO::FETCH_ASSOC);
                        $roomRate = $sumResults['SUM(rate)'];


                        if($count_rating != 0){
                            // Calculating to know avarage review   
                            $avgRating = $roomRate / $count_rating;
                        
                            $roundUp = round($avgRating); // Rounding value to a whole number
                        
                        }else{
                            $roundUp = 0; // Rounding value to a whole number
                        }

                ?>

                    <div class="col-lg-4 col-md-6 wow fadeInUp" data-wow-delay="0.1s">
                        <div class="room-item shadow rounded overflow-hidden">
                            <div class="position-relative">
                                <img class="img-fluid" src="admin/img/hotel_rooms/<?= $main_image ?>" alt="" style="width:500px; height:200px; object-fit:cover">
                                <small class="position-absolute start-0 top-100 translate-middle-y bg-primary text-white rounded py-1 px-3 ms-4">CFA <?= $room_price ?>/Night</small>
                                <?php

                                    if($is_available == "no"){
                                ?>
                                    <small class=" start-0 top-100 translate-middle-y text-white rounded py-1 px-3 ms-4" style="float:right; margin-right: 24px; background-color: #fe1616 !important;">Not Available Today</small>
                                <?php }else{?>
                                    <small class=" start-0 top-100 translate-middle-y text-white rounded py-1 px-3 ms-4" style="float:right; margin-right: 24px; background-color: #00c10f !important;">Available Today</small>
                                <?php }?>
                            </div>
                            <div class="p-4 mt-2">
                                <div class="d-flex justify-content-between mb-3">
                                    <h5 class="mb-0"><?= $room_title ?></h5>
                                    <?php
                                if($roundUp == 5){
                                ?>
                                    <div class="ps-2">
                                        <small class="fa fa-star text-primary"></small>
                                        <small class="fa fa-star text-primary"></small>
                                        <small class="fa fa-star text-primary"></small>
                                        <small class="fa fa-star text-primary"></small>
                                        <small class="fa fa-star text-primary"></small>
                                        <?= $roundUp ?>/5
                                    </div>
                                <?php }elseif($roundUp == 4){?>   
                                    <div class="ps-2">
                                        <small class="fa fa-star text-primary"></small>
                                        <small class="fa fa-star text-primary"></small>
                                        <small class="fa fa-star text-primary"></small>
                                        <small class="fa fa-star text-primary"></small>
                                        <small class="fa fa-star "></small>
                                        <?= $roundUp ?>/5
                                    </div>
                                <?php }elseif($roundUp == 3){?>   
                                    <div class="ps-2">
                                        <small class="fa fa-star text-primary"></small>
                                        <small class="fa fa-star text-primary"></small>
                                        <small class="fa fa-star text-primary"></small>
                                        <small class="fa fa-star "></small>
                                        <small class="fa fa-star "></small>
                                        <?= $roundUp ?>/5
                                    </div>
                                <?php }elseif($roundUp == 2){?>   
                                    <div class="ps-2">
                                        <small class="fa fa-star text-primary"></small>
                                        <small class="fa fa-star text-primary"></small>
                                        <small class="fa fa-star "></small>
                                        <small class="fa fa-star "></small>
                                        <small class="fa fa-star "></small>
                                        <?= $roundUp ?>/5
                                    </div>
                                    <?php }elseif($roundUp == 1){?>   
                                <div class="ps-2">
                                        <small class="fa fa-star text-primary"></small>
                                        <small class="fa fa-star "></small>
                                        <small class="fa fa-star "></small>
                                        <small class="fa fa-star "></small>
                                        <small class="fa fa-star "></small>
                                        <?= $roundUp ?>/5
                                    </div>
                                    <?php }else{ ?>
                                <div class="ps-2">
                                    <small class="fa fa-star "></small>
                                    <small class="fa fa-star "></small>
                                    <small class="fa fa-star "></small>
                                    <small class="fa fa-star "></small>
                                    <small class="fa fa-star "></small>
                                    <?= $roundUp ?>/5
                                </div>
                                <?php }?>  
                                </div>
                                <div class="d-flex mb-3">
                                    <small class="border-end me-3 pe-3"><i class="fa fa-bed text-primary me-2"></i><?= $no_beds ?> Bed</small>
                                    <small class="border-end me-3 pe-3"><i class="fa fa-bath text-primary me-2"></i><?= $no_baths ?> Bath</small>
                                    <?php

                                        if($wifi == 1){
                                    ?>
                                        <small><i class="fa fa-wifi text-primary me-2"></i>Wifi</small>
                                    <?php }?>
                                </div>
                                <p class="text-body mb-3"><?= $room_description ?></p>
                                <div class="d-flex justify-content-between">
                                    <a class="btn btn-sm btn-primary rounded py-2 px-4" href="view?room=<?= $room_code ;?>">View Detail</a>
                                    <a class="btn btn-sm btn-dark rounded py-2 px-4" href="view?room=<?= $room_code ;?>#booking">Book Now</a>
                                </div>
                            </div>
                        </div>
                    </div>

                <?php }
                
                ?>
                    
                </div>
            </div>
        </div>
        <!-- Room End -->


        <!-- Testimonial Start -->
        <div class="container-xxl testimonial mt-5 py-5 bg-dark wow zoomIn" data-wow-delay="0.1s" style="margin-bottom: 90px;">
            <div class="container">
                <div class="owl-carousel testimonial-carousel py-5">
                    <div class="testimonial-item position-relative bg-white rounded overflow-hidden">
                        <p>Tempor stet labore dolor clita stet diam amet ipsum dolor duo ipsum rebum stet dolor amet diam stet. Est stet ea lorem amet est kasd kasd et erat magna eos</p>
                        <div class="d-flex align-items-center">
                            <img class="img-fluid flex-shrink-0 rounded" src="img/testimonial-1.jpg" style="width: 45px; height: 45px;">
                            <div class="ps-3">
                                <h6 class="fw-bold mb-1">Client Name</h6>
                                <small>Profession</small>
                            </div>
                        </div>
                        <i class="fa fa-quote-right fa-3x text-primary position-absolute end-0 bottom-0 me-4 mb-n1"></i>
                    </div>
                    <div class="testimonial-item position-relative bg-white rounded overflow-hidden">
                        <p>Tempor stet labore dolor clita stet diam amet ipsum dolor duo ipsum rebum stet dolor amet diam stet. Est stet ea lorem amet est kasd kasd et erat magna eos</p>
                        <div class="d-flex align-items-center">
                            <img class="img-fluid flex-shrink-0 rounded" src="img/testimonial-2.jpg" style="width: 45px; height: 45px;">
                            <div class="ps-3">
                                <h6 class="fw-bold mb-1">Client Name</h6>
                                <small>Profession</small>
                            </div>
                        </div>
                        <i class="fa fa-quote-right fa-3x text-primary position-absolute end-0 bottom-0 me-4 mb-n1"></i>
                    </div>
                    <div class="testimonial-item position-relative bg-white rounded overflow-hidden">
                        <p>Tempor stet labore dolor clita stet diam amet ipsum dolor duo ipsum rebum stet dolor amet diam stet. Est stet ea lorem amet est kasd kasd et erat magna eos</p>
                        <div class="d-flex align-items-center">
                            <img class="img-fluid flex-shrink-0 rounded" src="img/testimonial-3.jpg" style="width: 45px; height: 45px;">
                            <div class="ps-3">
                                <h6 class="fw-bold mb-1">Client Name</h6>
                                <small>Profession</small>
                            </div>
                        </div>
                        <i class="fa fa-quote-right fa-3x text-primary position-absolute end-0 bottom-0 me-4 mb-n1"></i>
                    </div>
                </div>
            </div>
        </div>
        <!-- Testimonial End -->

<?php

include "includes/footer.php";

?>