<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Room Booking Calendar</title>
    <link href="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.0/main.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.0/main.min.js"></script>
</head>
<body>
    <div id="calendar"></div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            console.log('DOMContentLoaded event fired'); // Debugging statement
            var calendarEl = document.getElementById('calendar');

            var calendar = new FullCalendar.Calendar(calendarEl, {
                initialView: 'dayGridMonth',
                events: 'fetch-booked-dates.php',
                eventSourceSuccess: function(content, xhr) {
                    console.log('Event source success:', content); // Debugging statement
                },
                eventSourceFailure: function() {
                    console.log('Event source failure'); // Debugging statement
                    alert('There was an error while fetching events!');
                }
            });

            console.log('Rendering calendar'); // Debugging statement
            calendar.render();
        });
    </script>
</body>
</html>
