<?php

include "database/config.php";
include "database/temp_db.php";
include "includes/head.php";
include "includes/navbar.php";

//error_reporting(0);

$room_code = $_GET["room"] ;

$select_hotel_rooms = "SELECT * FROM hotel_rooms WHERE room_code = $room_code AND is_reserved = 0 ";
$select_hotel_rooms_result = mysqli_query($conn, $select_hotel_rooms);
$room = mysqli_fetch_assoc($select_hotel_rooms_result);

$room_id = $room["id"];
$room_title = $room["room_title"];
$room_prices = $room["room_price"];
$no_beds = $room["no_beds"];
$no_baths = $room["no_baths"];
$adult = $room["adult"];
$kids = $room["kids"];
$wifi = $room["wifi"];
$status = $room["status"];
$room_description = $room["room_description"];
$room_no = $room["room_no"];
$is_reserved = $room["is_reserved"];
$main_image = $room["main_image"];

$room_price = number_format($room_prices, 0, '.', ',');


// To set defult timezone
date_default_timezone_set("Africa/Douala");

$time_now = date( 'm/d/Y h:i A');

// Convert user input dates to UNIX timestamp for easier comparison
$user_checkin_timestamp = strtotime($time_now);
$user_checkout_timestamp = strtotime($time_now);

// Fetch existing reservations for the room from the database
$sql = "SELECT checkin, checkout FROM reservations WHERE room_code = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $room_code);
$stmt->execute();
$result = $stmt->get_result();

// Check for overlap with existing reservations
$room_available = true;
while ($row = $result->fetch_assoc()) {
    $existing_checkin_timestamp = strtotime($row['checkin']);
    $existing_checkout_timestamp = strtotime($row['checkout']);
    
    // Check for overlap
    if (
        ($user_checkin_timestamp < $existing_checkout_timestamp && $user_checkout_timestamp > $existing_checkin_timestamp)
        || ($user_checkin_timestamp == $existing_checkout_timestamp && $user_checkout_timestamp == $existing_checkin_timestamp)
    ) {
        $room_available = false;
        break;
    }
}

if ($room_available) {
    $is_available = "yes" ;
}else{
    $is_available = "no" ;
}



$ratings = "SELECT * FROM ratings WHERE room_code = $room_code " ;
$q = mysqli_query($conn, $ratings) ;
$r_results = mysqli_fetch_assoc($q);
$count_rating = mysqli_num_rows($q);

//verify 5star perecentage
$fiveStarRatings = "SELECT * FROM ratings WHERE room_code = $room_code AND rate = 5" ;
$fiveStar_query = mysqli_query($conn, $fiveStarRatings) ;
$count_fiveStarRating = mysqli_num_rows($fiveStar_query);

//verify 4star perecentage
$fourStarRatings = "SELECT * FROM ratings WHERE room_code = $room_code AND rate = 4" ;
$fourStar_query = mysqli_query($conn, $fourStarRatings) ;
$count_fourStarRating = mysqli_num_rows($fourStar_query);

//verify 3star perecentage
$threeStarRatings = "SELECT * FROM ratings WHERE room_code = $room_code AND rate = 3" ;
$threeStar_query = mysqli_query($conn, $threeStarRatings) ;
$count_threeStarRating = mysqli_num_rows($threeStar_query);

//verify 2star perecentage
$twoStarRatings = "SELECT * FROM ratings WHERE room_code = $room_code AND rate = 2" ;
$twoStar_query = mysqli_query($conn, $twoStarRatings) ;
$count_twoStarRating = mysqli_num_rows($twoStar_query);

//verify 1star perecentage
$oneStarRatings = "SELECT * FROM ratings WHERE room_code = $room_code AND rate = 1" ;
$oneStar_query = mysqli_query($conn, $oneStarRatings) ;
$count_oneStarRating = mysqli_num_rows($oneStar_query);

// getting the sum
$qrys = "SELECT SUM(rate) FROM ratings WHERE room_code =  $room_code";
$sumRate = $temp_db->prepare($qrys);
$sumRate->execute();
$sumResults = $sumRate->fetch(PDO::FETCH_ASSOC);
$roomRate = $sumResults['SUM(rate)'];



if($count_rating != 0){
    // Calculating to know avarage review   
    $avgRating = $roomRate / $count_rating;

    $roundUp = round($avgRating); // Rounding value to a whole number

    $fiveStarPercentage = $count_fiveStarRating / $count_rating * 100 ;
    $fourStarPercentage = $count_fourStarRating / $count_rating * 100 ;
    $threeStarPercentage = $count_threeStarRating / $count_rating * 100 ;
    $twoStarPercentage = $count_twoStarRating / $count_rating * 100 ;
    $oneStarPercentage = $count_oneStarRating / $count_rating * 100 ;

}else{
    $roundUp = 0; // Rounding value to a whole number

    $fiveStarPercentage = 0 ;
    $fourStarPercentage = 0 ;
    $threeStarPercentage = 0 ;
    $twoStarPercentage = 0 ;
    $oneStarPercentage = 0 ;
}


?>
        <!-- Page Header Start -->
        <div class="container-fluid page-header mb-5 p-0" style="background-image: url(img/carousel-1.jpg);">
            <div class="container-fluid page-header-inner py-5">
                <div class="container text-center pb-5">
                    <h1 class="display-3 text-white mb-3 animated slideInDown">Room No. <?= $room_no ?></h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb justify-content-center text-uppercase">
                            <li class="breadcrumb-item"><a href="./">Home</a></li>
                            <li class="breadcrumb-item text-white active" aria-current="page">View Room</li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
        <!-- Page Header End -->



        <!-- Booking Start -->
        <div class="container-xxl py-5">
            <div class="container">
                <div class="text-center wow fadeInUp" data-wow-delay="0.1s">
                    <h6 class="section-title text-center text-primary text-uppercase">Room info</h6>
                    <h1 class="mb-5">Viewing <span class="text-primary text-uppercase"><?= $room_title ?></span></h1>
                </div>
                <div class="row g-5">
                    <div class="col-lg-6">
                        <a href="admin/img/hotel_rooms/<?= $main_image ?>" data-lightbox="room-gallery" data-title="Main Room Image">
                            <img data-wow-delay="0.1s" src="admin/img/hotel_rooms/<?= $main_image ?>" alt="" style="width:100%; height:350px; object-fit:cover; border-radius:20px">
                        </a>  
                        <br>
                        <br>
                        <div class="room_gallery d-flex">
                            <?php

                                $select_gallery = "SELECT * FROM room_images WHERE room_code = $room_code " ;
                                $select_result = mysqli_query($conn, $select_gallery) ;
                                while($gallery = mysqli_fetch_assoc($select_result)){

                                    $image = $gallery["room_image"] ;
                            
                            ?>
                                <a href="admin/img/hotel_rooms/<?= $image ?>" data-lightbox="room-gallery" data-title="Room Image gallery">
                                    <img data-wow-delay="0.1s" src="admin/img/hotel_rooms/<?= $image ?>" alt="">
                                </a>
                            <?php } ?>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="wow fadeInUp" data-wow-delay="0.2s">
                            <h1 style="margin-bottom: 17px">Room <span class="text-primary text-uppercase">Details</span></h1>
                            <h6 class="text-primary text-uppercase" style="margin-bottom: 10px">Room Description</h6>
                            <p style="margin-bottom:20px"><?= $room_description?></p>
                            <h6 class="text-primary text-uppercase" style="margin-bottom: 10px">About Room</h6>
                            <div class="d-flex mb-3">
                                <small class="border-end me-3 pe-3"><i class="fa fa-bed text-primary me-2"></i><?= $no_beds ?> Bed</small>
                                <small class="border-end me-3 pe-3"><i class="fa fa-bath text-primary me-2"></i><?= $no_baths ?> Bath</small>
                                <?php

                                    if($wifi == 1){
                                ?>
                                    <small><i class="fa fa-wifi text-primary me-2"></i>Wifi</small>
                                <?php }?>
                            </div>
                            <div class="d-flex mb-3">
                                <small class="border-end me-3 pe-3"><i class="fa fa-user text-primary me-2"></i><?= $no_beds ?> Adult(s) maximum</small>
                                <small class="border-end me-3 pe-3"><i class="fa fa-users text-primary me-2"></i><?= $no_baths ?> Kid(s) maximum</small>
                            </div>
                            <div class="d-flex mb-3">
                                <h5 class="mb-0">Room rating (<?= $count_rating ?>)</h5>
                                <?php
                                if($roundUp == 5){
                                ?>
                                    <div class="ps-2">
                                        <small class="fa fa-star text-primary"></small>
                                        <small class="fa fa-star text-primary"></small>
                                        <small class="fa fa-star text-primary"></small>
                                        <small class="fa fa-star text-primary"></small>
                                        <small class="fa fa-star text-primary"></small>
                                        <?= $roundUp ?>/5
                                    </div>
                                <?php }elseif($roundUp == 4){?>   
                                    <div class="ps-2">
                                        <small class="fa fa-star text-primary"></small>
                                        <small class="fa fa-star text-primary"></small>
                                        <small class="fa fa-star text-primary"></small>
                                        <small class="fa fa-star text-primary"></small>
                                        <small class="fa fa-star "></small>
                                        <?= $roundUp ?>/5
                                    </div>
                                <?php }elseif($roundUp == 3){?>   
                                    <div class="ps-2">
                                        <small class="fa fa-star text-primary"></small>
                                        <small class="fa fa-star text-primary"></small>
                                        <small class="fa fa-star text-primary"></small>
                                        <small class="fa fa-star "></small>
                                        <small class="fa fa-star "></small>
                                        <?= $roundUp ?>/5
                                    </div>
                                <?php }elseif($roundUp == 2){?>   
                                    <div class="ps-2">
                                        <small class="fa fa-star text-primary"></small>
                                        <small class="fa fa-star text-primary"></small>
                                        <small class="fa fa-star "></small>
                                        <small class="fa fa-star "></small>
                                        <small class="fa fa-star "></small>
                                        <?= $roundUp ?>/5
                                    </div>
                                    <?php }elseif($roundUp == 1){?>   
                                <div class="ps-2">
                                        <small class="fa fa-star text-primary"></small>
                                        <small class="fa fa-star "></small>
                                        <small class="fa fa-star "></small>
                                        <small class="fa fa-star "></small>
                                        <small class="fa fa-star "></small>
                                        <?= $roundUp ?>/5
                                    </div>
                                    <?php }else{ ?>
                                <div class="ps-2">
                                    <small class="fa fa-star "></small>
                                    <small class="fa fa-star "></small>
                                    <small class="fa fa-star "></small>
                                    <small class="fa fa-star "></small>
                                    <small class="fa fa-star "></small>
                                    <?= $roundUp ?>/5
                                </div>
                                <?php }?>  
                            </div>
                            <div class="d-flex mb-3">
                                <h5 class="mb-0">Room Status:</h5>
                                <div class="ps-2">
                                    <?php

                                        if($is_available == "no"){
                                    ?>
                                        <small class=" start-0 top-100 translate-middle-y text-white rounded py-1 px-3 ms-4" style="margin-right: 24px; background-color: #fe1616 !important;">Not Available at the Moment</small>
                                    <?php }else{?>
                                        <small class=" start-0 top-100 translate-middle-y text-white rounded py-1 px-3 ms-4" style="margin-right: 24px; background-color: #00c10f !important;">Available at the Moment</small>
                                    <?php }?>
                                </div>
                            </div>
                            <hr>
                            <!-- Large modal -->
                            <a type="button" class="btn btn-dark" href="#booking">Book Now</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Booking End -->


        <div class="rating_section">
            <div class="modolos">
                <div class="text-center" data-wow-delay="0.1s">
                    <h6 class="section-title text-center text-primary text-uppercase">Ratings</h6>
                    <h1 class="mb-5">Rate <span class="text-primary text-uppercase"><?= $room_title ?></span></h1>
                </div>
                <div class="row">
                    <div class="text-center col col-md-6">
                        <h1 style="font-size: 87px;"><?= $roundUp ?></h1>
                        <span>Reviews (<?= $count_rating ?>)</span>
                    </div>
                    <div class="col col-md-6">
                        <div class="progress" style="margin-bottom:5px">
                            <div class="progress-bar" role="progressbar"  style="width: <?= $fiveStarPercentage ?>%" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100">5 Star</div>
                        </div>
                        <div class="progress"  style="margin-bottom:5px">
                            <div class="progress-bar" role="progressbar"  style="width: <?= $fourStarPercentage ?>%" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100">4 Star</div>
                        </div>
                        <div class="progress"  style="margin-bottom:5px">
                            <div class="progress-bar" role="progressbar"  style="width: <?= $threeStarPercentage ?>%" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100">3 Star</div>
                        </div>
                        <div class="progress"  style="margin-bottom:5px">
                            <div class="progress-bar" role="progressbar"  style="width: <?= $twoStarPercentage ?>%" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100">2 Star</div>
                        </div>
                        <div class="progress"  style="margin-bottom:5px">
                            <div class="progress-bar" role="progressbar"  style="width: <?= $oneStarPercentage ?>%" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100">1 Star</div>
                        </div>
                        <br>
                        <h6>Wrtite a review</h6>
                        <div class="cont" style="width: 140px;">
                            <div class="star-widget">
                                <input type="radio" name="rate" id="rate-5" value="5">
                                <label for="rate-5" class="fa fa-star"></label>
                                <input type="radio" name="rate" id="rate-4" value="4">
                                <label for="rate-4" class="fa fa-star"></label>
                                <input type="radio" name="rate" id="rate-3" value="3">
                                <label for="rate-3" class="fa fa-star"></label>
                                <input type="radio" name="rate" id="rate-2" value="2">
                                <label for="rate-2" class="fa fa-star"></label>
                                <input type="radio" name="rate" id="rate-1" value="1" checked>
                                <label for="rate-1" class="fa fa-star"></label>
                                <small style="color:red; display:none;" id="star_error">Please select a Star</small>
                            </div>
                            <br>
                            <br>
                        </div>
                        <input type="text" placeholder="Subject" id="subject" class="form-control">
                        <input type="hidden" value="<?= $room_code ?>" id="room_code">
                        <br>
                        <textarea name="" id="review" cols="30" rows="3" class="form-control" placeholder="Write a review"></textarea>
                        <br>
                        <button type="button" class="btn btn-dark" onclick="rate()"><img src="img/loader.gif" alt="" id="rate_loader" style="width:23px; display:none"> Post</button>
                        <span class="text-success" style="display:none" id="rate_success">Successful</span>

                    </div>
                </div>
                <br><br>
                <div class="reviews">

                    <?php

                        $select_rates = "SELECT * FROM ratings WHERE room_code = $room_code ORDER BY id DESC" ;
                        $select_q = mysqli_query($conn, $select_rates) ;
                        while($r = mysqli_fetch_assoc($select_q)){

                        $subject = $r["subject"] ;
                        $rate = $r["rate"] ;
                        $review = $r["review"] ;
                    
                    
                    ?>

                    <div class="review" style="width:auto; background-color:#fea1161c; padding:10px; border-radius:7px; margin-bottom:5px">
                        <h6><?= $subject ?></h6>

                        <?php
                            if($rate == 5){
                        ?>
                            <div class="ps-2">
                                <small class="fa fa-star text-primary"></small>
                                <small class="fa fa-star text-primary"></small>
                                <small class="fa fa-star text-primary"></small>
                                <small class="fa fa-star text-primary"></small>
                                <small class="fa fa-star text-primary"></small>
                            </div>
                         <?php }elseif($rate == 4){?>   
                            <div class="ps-2">
                                <small class="fa fa-star text-primary"></small>
                                <small class="fa fa-star text-primary"></small>
                                <small class="fa fa-star text-primary"></small>
                                <small class="fa fa-star text-primary"></small>
                                <small class="fa fa-star "></small>
                            </div>
                        <?php }elseif($rate == 3){?>   
                            <div class="ps-2">
                                <small class="fa fa-star text-primary"></small>
                                <small class="fa fa-star text-primary"></small>
                                <small class="fa fa-star text-primary"></small>
                                <small class="fa fa-star "></small>
                                <small class="fa fa-star "></small>
                            </div>
                        <?php }elseif($rate == 2){?>   
                            <div class="ps-2">
                                <small class="fa fa-star text-primary"></small>
                                <small class="fa fa-star text-primary"></small>
                                <small class="fa fa-star "></small>
                                <small class="fa fa-star "></small>
                                <small class="fa fa-star "></small>
                            </div>
                            <?php }else{?>   
                        <div class="ps-2">
                                <small class="fa fa-star text-primary"></small>
                                <small class="fa fa-star "></small>
                                <small class="fa fa-star "></small>
                                <small class="fa fa-star "></small>
                                <small class="fa fa-star "></small>
                            </div>
                        <?php }?>  
                        <p><?= $review ?></p>
                    </div>
                    
                    <?php } ?>
                  
                </div>
            </div>
        </div>


        <div id="booking" class=" fadeInUp">
            <div class="modals-content">
                <!-- <span class="close" id="close">&times;</span> -->
                <div class="text-center" data-wow-delay="0.1s">
                    <h6 class="section-title text-center text-primary text-uppercase">Room info</h6>
                    <h1 class="mb-5">Reserving <span class="text-primary text-uppercase"><?= $room_title ?></span></h1>
                </div>
                <div class="row g-5">
                    <div class="col-lg-6">
                        <div id="calendar"></div>
                    </div>
                    <div class="col-lg-6">
                        <h1 style="margin-bottom: 17px">Booking <span class="text-primary text-uppercase">Details</span></h1>
                        <div class="row">
                            <div class="col col-md-4">
                                <label for="guest_name">Guest Name <span style="color:red"> *</span></label>
                                <input type="text" name="guest_name" id="guest_name" class="form-control">
                            </div>
                            <div class="col col-md-4">
                                <label for="guest_tel">Phone <span style="color:red"> *</span></label>
                                <input type="text" name="guest_tel" id="guest_tel" class="form-control">
                            </div>
                            <div class="col col-md-4">
                                <label for="guest_gender">Guest Name <span style="color:red"> *</span></label>
                                <select type="text" name="guest_gender" id="guest_gender" class="form-control">
                                    <option value="" selected>Choose Gendar</option>
                                    <option value="Male">Male</option>
                                    <option value="Female">Female</option>
                                </select>
                            </div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col col-md-6">
                                <label for="adults">No of Adults <span style="color:red"> *</span></label>
                                <input type="number" name="adults" id="adults" class="form-control">
                            </div>
                            <div class="col col-md-6">
                                <label for="kids">No of Kids <span style="color:red"> *</span></label>
                                <input type="number" name="kids" id="kids" class="form-control">
                            </div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="date" id="date1" data-target-input="nearest">
                                    <label for="checkin">CheckIn <span style="color:red"> *</span></label>
                                    <input type="text" class="form-control datetimepicker-input"
                                        placeholder="Check in" data-target="#date1" data-toggle="datetimepicker" id="checkin" />
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="date" id="date2" data-target-input="nearest">
                                    <label for="checkout">CheckOut <span style="color:red"> *</span></label>
                                    <input type="text" class="form-control datetimepicker-input" id="checkout" placeholder="Check out" data-target="#date2" data-toggle="datetimepicker"/>
                                </div>
                            </div>
                        </div>
                        <br>
                        <div class="row">
                            <div class="col col-md-12">
                                <label for="special_note">Special Note (optional)</label>
                                <textarea name="" class="form-control" id="special_note" cols="30" rows="3"></textarea>

                                <input type="hidden" value="<?= $room_code; ?>" id="room_code">
                            </div>
                        </div>
                        <br>
                        <button type="button" class="btn btn-dark" onclick="reserve()"><img src="img/loader.gif" alt="" id="loader" style="width:23px; display:none"> Reserve</button>
                    </div>
                </div>
            </div>
        </div>



        <script>
            function reserve(){
                var guest_name = $("#guest_name").val();
                var guest_tel = $("#guest_tel").val();
                var guest_gender = $("#guest_gender").val();
                var adults = $("#adults").val();
                var kids = $("#kids").val();
                var checkin = $("#checkin").val();
                var checkout = $("#checkout").val();
                var special_note = $("#special_note").val();
                var room_code = $("#room_code").val();
                //Conditions to meet before submiting details
                if(guest_name == ""){
                    var guest_name_check = document.getElementById("guest_name")
                    guest_name_check.style.border = "1px solid red";
                }else if(guest_tel == ""){
                    var guest_tel_check = document.getElementById("guest_tel")
                    guest_tel_check.style.border = "1px solid red";
                }else if(guest_gender == ""){
                    var guest_gender_check = document.getElementById("guest_gender")
                    guest_gender_check.style.border = "1px solid red";
                }else if(adults == ""){
                    var adults_check = document.getElementById("adults")
                    adults_check.style.border = "1px solid red";
                }else if(kids == ""){
                    var kids_check = document.getElementById("kids")
                    kids_check.style.border = "1px solid red";
                }else if(checkin == ""){
                    var checkin_check = document.getElementById("checkin")
                    checkin_check.style.border = "1px solid red";
                }else if(checkout == ""){
                    var checkout_check = document.getElementById("checkout")
                    checkout_check.style.border = "1px solid red";
                }else{
                    $.ajax({
                        url: "api/reserve",
                        type: "POST",
                        data: {
                            guest_name,
                            guest_tel,
                            guest_gender,
                            adults,
                            kids,
                            checkin,
                            checkout,
                            special_note,
                            room_code,
                        },
                        beforeSend:()=>{
                            $("#loader").show();
                        },
                        complete:()=>{
                            $("#loader").hide();
                        },
                        success:function(response){
                            data = response.trim();
                            alert(data)
                        }
                    });
                }
            }



            function rate(){
                var rate = $("input[name='rate']:checked").val();
                var room_code = $("#room_code").val() ;
                var subject = $("#subject").val() ;
                var review = $("#review").val() ;

                if(rate == ""){
                    $("#star_error").show();
                }else if(subject == ""){
                    var subject_check = document.getElementById("subject")
                    subject_check.style.border = "1px solid red";
                }else if(review == ""){
                    var review_check = document.getElementById("review")
                    review_check.style.border = "1px solid red";
                }else{
                    $.ajax({
                        url: "api/rate.php",
                        type: "POST",
                        data: {rate, room_code, subject, review},
                        beforeSend:()=>{
                            $("#rate_loader").show();
                        },
                        complete:()=>{
                            $("#rate_loader").hide();
                        },
                        success:function(response){
                            data = response.trim();
                            if(data == "yes"){
                                $("#rate_success").show() ;
                            }
                        }
                    })
                }
                

            }
        </script>








        <script>
            // Get the modal
            var modal = document.getElementById("myModal");

            // Get the button that opens the modal
            var btn = document.getElementById("openModalBtn");

            // Get the <span> element that closes the modal
            var span = document.getElementsByClassName("close")[0];

            // When the user clicks the button, open the modal 
            btn.onclick = function() {
                modal.style.display = "block";
            }

            // When the user clicks on <span> (x), close the modal
            span.onclick = function() {
                modal.style.display = "none";
            }

            // When the user clicks anywhere outside of the modal, close it
            window.onclick = function(event) {
                if (event.target == modal) {
                    modal.style.display = "none";
                }
            }

        </script>




    <script>

        document.addEventListener('DOMContentLoaded', function() {
            console.log('DOMContentLoaded event fired'); // Debugging statement
            var calendarEl = document.getElementById('calendar');
            var roomCode = <?= $room_code?>; // Example room code, replace with your dynamic value

            var calendar = new FullCalendar.Calendar(calendarEl, {
                initialView: 'dayGridMonth',
                events: {
                    url: 'api/fetch-booked-dates.php',
                    method: 'GET',
                    extraParams: {
                        room_code: roomCode
                    },
                    failure: function() {
                        console.log('Event source failure'); // Debugging statement
                        alert('There was an error while fetching events!');
                    }
                },
                eventSourceSuccess: function(content, xhr) {
                    console.log('Event source success:', content); // Debugging statement
                }
            });

            console.log('Rendering calendar'); // Debugging statement
            calendar.render();
        });



    </script>





        <script src="https://cdnjs.cloudflare.com/ajax/libs/lightbox2/2.11.3/js/lightbox.min.js"></script>

<?php

include "includes/footer.php";

?>